% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-generic-spct.R
\name{generic_plot}
\alias{generic_plot}
\title{Create a complete ggplot for generic spectral data.}
\usage{
generic_plot(
  spct,
  y.name,
  ymin.name,
  ymax.name,
  ylab,
  w.band,
  range,
  label.qty,
  span,
  wls.target,
  annotations,
  by.group,
  text.size,
  idfactor,
  facets,
  ylim,
  na.rm
)
}
\arguments{
\item{spct}{a generic_spct object}

\item{y.name, ymin.name, ymax.name}{character Names of the columns to be mapped
to the y aesthetic.}

\item{ylab}{character or expression The y-axis label.}

\item{w.band}{list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{label.qty}{character string giving the type of summary quantity to use
for labels, one of "mean", "total", "contribution", and "relative".}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{wls.target}{numeric vector indicating the spectral quantity values for
which wavelengths are to be searched and interpolated if need. The
\code{character} strings "half.maximum" and "half.range" are also accepted
as arguments. A list with \code{numeric} and/or \code{character} values is
also accepted.}

\item{annotations}{a character vector}

\item{by.group}{logical flag If TRUE repeated identical annotation layers are
added for each group within a plot panel as needed for animation. If
\code{FALSE}, the default, single layers are added per panel.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{idfactor}{character Name of an index column in data holding a
\code{factor} with each spectrum in a long-form multispectrum object
corresponding to a distinct spectrum. If \code{idfactor=NULL} the name of
the factor is retrieved from metadata or if no metadata found, the
default "spct.idx" is tried.}

\item{facets}{logical or integer Indicating if facets are to be created for
the levels of \code{idfactor} when \code{spct} contain multiple spectra in
long form.}

\item{ylim}{numeric y axis limits,}

\item{na.rm}{logical.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a
\code{generic_spct object}.
}
\note{
Note that scales are expanded so as to make space for the annotations. The
object returned is a ggplot object, and can be further manipulated. When spct
has more than one column with spectral data, each of these columns is
normalized individually.
}
\keyword{internal}
