% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_agegroups.R
\name{create_agegroups}
\alias{create_agegroups}
\title{Create Age Groups from Numeric Values}
\usage{
create_agegroups(
  values,
  age_breaks = c(5, 10, 15, 20, 25, 30, 40, 50, 60, 70, 80, 90),
  breaks_as_lower_bound = TRUE,
  first_group_format = "0-{x}",
  interval_format = "{x}-{y}",
  last_group_format = "{x}+",
  pad_numbers = FALSE,
  pad_with = "0",
  collapse_single_year_groups = FALSE,
  na_label = NA,
  return_factor = FALSE
)
}
\arguments{
\item{values}{Numeric vector of ages to be grouped}

\item{age_breaks}{Numeric vector of break points for age groups. \cr
Default: \code{c(5, 10, 15, 20, 25, 30, 40, 50, 60, 70, 80, 90)}}

\item{breaks_as_lower_bound}{Logical; if \code{TRUE} (default), breaks define the the lower bounds of the intervals (e.g., a break at 5 starts the '5-9' group).
If \code{FALSE}, breaks define the upper bound (e.g., a break at 5 ends the '0-5' group).}

\item{first_group_format}{Character string template for the first age group. Uses \link[glue:glue]{glue::glue} syntax. \cr
The variable \code{x} represents the upper bound of the first interval.\cr
Default: \code{"0-{x}"}. Other common styles: \code{"<={x}", "<{x+1}"}}

\item{interval_format}{Character string template for intermediate age groups. Uses \link[glue:glue]{glue::glue} syntax.\cr
The variables \code{x} and \code{y} represent the lower and upper bounds of the interval, respectively.\cr
Default: \code{"{x}-{y}"}. Other common styles: \code{"{x} to {y}"}}

\item{last_group_format}{Character string template for the last age group. Uses \link[glue:glue]{glue::glue} syntax. \cr
The variable \code{x} represents the lower bound of the last interval.\cr
Default: \code{"{x}+"}. Other common styles: \code{">={x}",">{x-1}"}}

\item{pad_numbers}{Logical or numeric; if numeric, pad numbers up to the specified length (Tip: use \code{2}).
Not compatible with calculations within glue formats. Default: \code{FALSE}}

\item{pad_with}{Character to use for padding numbers. Default: \code{"0"}}

\item{collapse_single_year_groups}{Logical; if \code{TRUE}, groups spanning a single year (e.g., from \code{age_breaks = c(1, 2)})
are formatted as a single number (e.g., "1") instead of a range (e.g., "1-1"). Default: \code{FALSE}}

\item{na_label}{Label for \code{NA} values. If \code{NA}, keeps default \code{NA} handling. Default: \code{NA}}

\item{return_factor}{Logical; if \code{TRUE}, returns a factor, if \code{FALSE} returns character vector. Default: \code{FALSE}}
}
\value{
Vector of age group labels (character or factor depending on return_factor)
}
\description{
Creates age groups from numeric values using customizable break points and formatting options.
The function allows for flexible formatting and customization of age group labels.

If a factor is returned, this factor includes factor levels of unobserved age groups.
This allows for reproducible age groups, which can be used for joining data
(e.g. adding age grouped population numbers for incidence calculation).
}
\examples{
# Basic usage
create_agegroups(1:100)

# Custom formatting with upper bounds
create_agegroups(1:100,
  breaks_as_lower_bound = FALSE,
  interval_format = "{x} to {y}",
  first_group_format = "0 to {x}"
)

# Ages 1 to 5 are kept as numbers by collapsing single year groups
create_agegroups(1:10,
  age_breaks = c(1, 2, 3, 4, 5, 10),
  collapse_single_year_groups = TRUE
)

}
