% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-qc.R
\name{run_qc}
\alias{run_qc}
\title{Run Quality Control Checks}
\usage{
run_qc(
  gimap_dataset,
  output_file,
  plots_dir,
  overwrite = FALSE,
  filter_zerocount_target_col = NULL,
  filter_plasmid_target_col = NULL,
  filter_replicates_target_col = NULL,
  open_results = TRUE,
  ...
)
}
\arguments{
\item{gimap_dataset}{A special dataset structure that is setup using the
`setup_data()` function.}

\item{output_file}{Needs to be a string that ends with ".Rmd" What the
name of the output QC report file should be.}

\item{plots_dir}{directory to save plots created with this function,
if it doesn't exist already it will be created}

\item{overwrite}{default is FALSE; whether to overwrite the QC Report file}

\item{filter_zerocount_target_col}{default is NULL; Which sample column(s)
should be
 used to check for counts of 0?  If NULL and not specified, downstream
 analysis will select all sample columns}

\item{filter_plasmid_target_col}{default is NULL; Which sample columns(s)
should be used to look at log2
CPM expression for plasmid pgRNA constructs? If NULL and not specified,
downstream analysis
will select the first sample column only}

\item{filter_replicates_target_col}{default is NULL; Which sample columns
are replicates whose variation you'd like to analyze; If NULL, the last
3 sample columns are used}

\item{open_results}{default is TRUE but if you don't want the report
automatically opened, choose FALSE.}

\item{...}{additional parameters are sent to `rmarkdown::render()`}
}
\value{
a QC report saved locally
}
\description{
This function takes a `gimap_dataset` and creates a QC report
}
\examples{
\dontrun{

gimap_dataset <- get_example_data("gimap")

run_qc(
  gimap_dataset,
  plots_dir = tempdir(),
  output_file = paste0(tempfile(), "_QC_Report.Rmd")
)
}
}
