% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwfit.R
\name{vcov.gkwfit}
\alias{vcov.gkwfit}
\title{Extract Variance-Covariance Matrix from a gkwfit Object}
\usage{
\method{vcov}{gkwfit}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"gkwfit"}, typically the result of a call to \code{\link{gkwfit}}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A numeric matrix representing the variance-covariance matrix of the
estimated model parameters. Row and column names correspond to the parameter
names (e.g., \code{"alpha"}, \code{"beta"}, etc.). Returns \code{NULL} or
raises a warning/error if the matrix is not available (e.g., if \code{hessian=FALSE}
was used or if the Hessian computation failed).
}
\description{
Extracts the variance-covariance matrix of the estimated parameters from a model
fitted by \code{\link{gkwfit}}. This matrix is typically derived from the
inverse of the observed Hessian matrix calculated during fitting (requires
\code{hessian = TRUE} in the \code{\link{gkwfit}} call). This is an S3 method
for the generic \code{\link[stats]{vcov}} function.
}
\examples{
\donttest{
# Generate data and fit model (ensure hessian = TRUE for vcov)
set.seed(2203)
y <- rbkw(50, alpha = 2, beta = 3, gamma = 1.5, delta = 0.5)
fit <- gkwfit(data = y, family = "bkw", plot = FALSE, hessian = TRUE)

# Extract variance-covariance matrix
vcov_matrix <- vcov(fit)
print(vcov_matrix)

# Extract standard errors from the diagonal
std_errors <- sqrt(diag(vcov_matrix))
print(std_errors)

# Compare with standard errors from summary
summary_se <- summary(fit)$coefficients[, "Std. Error"]
all.equal(std_errors, summary_se)
}

}
\seealso{
\code{\link{gkwfit}}, \code{\link[stats]{vcov}}, \code{\link{coef.gkwfit}}, \code{\link{logLik.gkwfit}}
}
\author{
Lopes, J. E.
}
\keyword{methods}
\keyword{models}
