% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{prepare_samples_clim}
\alias{prepare_samples_clim}
\title{Prepare tree-ring data for downstream analysis}
\usage{
prepare_samples_clim(dt.samples_trt, dt.clim = NULL, calbai = TRUE)
}
\arguments{
\item{dt.samples_trt}{A list of tree-ring data formatted by
\code{CFS_format()}.}

\item{dt.clim}{An optional data frame containing climate variables,
joined by \code{site_id} and \code{year}. Default is \code{NULL}.}

\item{calbai}{Logical. If \code{TRUE}, basal area increment (BAI) is
computed. Default is \code{TRUE}.}
}
\value{
A data frame or data.table containing tree-ring measurements,
optionally including basal area increment and merged climate variables.
}
\description{
This function prepares tree-ring data including ring-width
measurements, and optionally computes basal area increment (BAI)
and merges climate variables.
}
\examples{

# loading processed data
dt.samples_trt <- readRDS(system.file("extdata", "dt.samples_trt.rds", package = "growthTrendR"))
# climate
dt.clim <- data.table::fread(system.file("extdata", "dt.clim.csv", package = "growthTrendR"))
# pre-data for model
dt.samples_clim <- prepare_samples_clim(dt.samples_trt, dt.clim)
}
