% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_different.R
\name{is_different}
\alias{is_different}
\alias{is_equal}
\alias{cumdifferent}
\alias{num_cycle}
\title{Comparison tests considering \code{NA} as values to be compared}
\usage{
is_different(x, y)

is_equal(x, y)

cumdifferent(x)

num_cycle(x)
}
\arguments{
\item{x, y}{Vectors to be compared.}
}
\value{
A vector of the same length as \code{x}.
}
\description{
\code{is_different()} and \code{is_equal()} performs comparison tests, considering
\code{NA} values as legitimate values (see examples).
}
\details{
\code{cum_different()} allows to identify groups of continuous rows that have
the same value. \code{num_cycle()} could be used to identify sub-groups that
respect a certain condition (see examples).

\code{is_equal(x, y)} is equivalent to
\code{(x == y & !is.na(x) & !is.na(y)) | (is.na(x) & is.na(y))}, and
\code{is_different(x, y)} is equivalent to
\code{(x != y & !is.na(x) & !is.na(y)) | xor(is.na(x), is.na(y))}.
}
\examples{
v <- c("a", "b", NA)
is_different(v, "a")
is_different(v, NA)
is_equal(v, "a")
is_equal(v, NA)
d <- dplyr::tibble(group = c("a", "a", "b", "b", "a", "b", "c", "a"))
d |>
  dplyr::mutate(
    subgroup = cumdifferent(group),
    sub_a = num_cycle(group == "a")
  )
}
\keyword{logic}
