% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radial_plot.R
\name{radialPlot}
\alias{radialPlot}
\title{Draw radial plot for a degrees data frame}
\usage{
radialPlot(
  degreesDF,
  title = "Radial plot",
  degreeLegendTitle = "Degree",
  groupLegendTitle = "Group",
  extraCircles = 0,
  palette = rpColors(length(unique(degreesDF[, 3]))),
  labelSize = 3,
  pointSize = 0.8,
  labelRepulsion = 1,
  labelPull = 0,
  maxOverlaps = 10,
  ...
)
}
\arguments{
\item{degreesDF}{A data frame with names on the first column and
positive integers on the second column.}

\item{title}{Plot title.}

\item{degreeLegendTitle}{Legend title corresponding to the positive integer
column.}

\item{groupLegendTitle}{Legend title corresponding to the categorical
column.}

\item{extraCircles}{Number of circles drawn beyond those required to include
the points representing the genes.}

\item{palette}{Color palette.}

\item{labelSize}{Label size.}

\item{pointSize}{Point size.}

\item{labelRepulsion}{Repulsion strength between labels.}

\item{labelPull}{Attraction strength between a text label
and its data point.}

\item{maxOverlaps}{Maximum overlaps. Ignored if \code{labelDF}
is \code{NULL}.}

\item{...}{Other arguments passed to \code{centerTitle}.}
}
\value{
An object of class \code{gg}.
}
\description{
This function draws a radial plot for a degrees data frame, plotting
positive integer-valued points over concentric circles, with points located
more centrally representing higher values.
}
\examples{
degreesDF <- data.frame(Protein = paste0('P', seq(20)),
Degree = sample(10, 20, replace=TRUE),
Group = sample(3, 20, replace=TRUE))
radialPlot(degreesDF)

}
