% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dggrid.R
\name{dggrid_43h_sequence}
\alias{dggrid_43h_sequence}
\title{Create DGGRID 43H aperture sequence}
\usage{
dggrid_43h_sequence(num_ap4, num_ap3)
}
\arguments{
\item{num_ap4}{Number of aperture-4 resolutions}

\item{num_ap3}{Number of aperture-3 resolutions}
}
\value{
Integer vector of aperture sequence
}
\description{
Create an aperture sequence following DGGRID's 43H pattern:
first num_ap4 resolutions use aperture 4, then aperture 3.
}
\examples{
# DGGRID 43H with 2 ap4 resolutions, then 3 ap3 resolutions
seq <- dggrid_43h_sequence(2, 3)  # c(4, 4, 3, 3, 3)
}
\seealso{
Other 'dggridR' compatibility: 
\code{\link{as_dggrid}()},
\code{\link{dggrid_is_compatible}()},
\code{\link{from_dggrid}()}
}
\concept{'dggridR' compatibility}
\keyword{internal}
