% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gettest.R
\name{get_test}
\alias{get_test}
\title{Get test that is attached to object as "test" attribute}
\usage{
get_test(object)
}
\arguments{
\item{object}{to which the test is attached}
}
\value{
the test (function)
}
\description{
The returned function can be executed. If that is done within a
\link[testthat:Reporter]{testthat::Reporter}, the results will be reported accordingly. Without
reporter, the test runs silently if successful and stops if it fails.
}
\examples{

f <- function(x) x^2

test(f) <- function() {
   context("f")

   test_that("correct result for complex number", {
     expect_equal(f(1i), -1 + 0i)
   })
}

get_test(f)

library(testthat)
## execute the test
get_test(f)()

with_reporter("summary", get_test(f)())
}
