% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{as.raster.ijtiff_img}
\alias{as.raster.ijtiff_img}
\title{Convert an ijtiff_img object to a raster object for plotting}
\usage{
\method{as.raster}{ijtiff_img}(x, ...)
}
\arguments{
\item{x}{An \link{ijtiff_img} object. This should be a 4D array with
dimensions representing (y, x, channel, frame).}

\item{...}{Passed to \code{\link[graphics:plot.raster]{graphics::plot.raster()}}.}
}
\value{
A \code{raster} object compatible with \code{\link[graphics:plot.raster]{graphics::plot.raster()}}. The
raster will represent the first frame of the input image.
}
\description{
This function converts an \link{ijtiff_img} object to a \code{raster} object that can
be used with base R graphics functions. The function extracts the first frame
of the image and converts it to an RGB raster representation.
}
\details{
The function performs the following operations:
\itemize{
\item Extracts the first frame of the image
\item Checks for invalid values (all NA or negative values)
\item Determines the appropriate color scaling based on the image bit depth
\item Creates an RGB representation using the available channels
}

For single-channel images, a grayscale representation is created. For RGB
images (3 channels), a full-color representation is created.
}
\examples{
# Read a TIFF image
img <- read_tif(system.file("img", "Rlogo.tif", package = "ijtiff"))

# Convert to raster and plot
raster_img <- as.raster(img)
plot(raster_img)

}
