% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSetPieces.R
\name{getSetPieces}
\alias{getSetPieces}
\title{Return a dataframe that contains all set pieces and aggregated kpi values per
set piece sub phase for a set of given list of match IDs}
\usage{
getSetPieces(matches, token, host = "https://api.impect.com")
}
\arguments{
\item{matches}{list fo 'IMPECT' match IDs}

\item{token}{bearer token}

\item{host}{host environment}
}
\value{
a dataframe containing all set pieces and aggregated kpi values per
set piece sub phase for a set of given list of match IDs
}
\description{
Return a dataframe that contains all set pieces and aggregated kpi values per
set piece sub phase for a set of given list of match IDs
}
\examples{
# Toy example: this will error quickly (no API token)
try(set_pieces <- getSetPieces(
  matches = c(0, 1),
  token = "invalid"
))

# Real usage: requires valid Bearer Token from `getAccessToken()`
\dontrun{
set_pieces <- getSetPieces(
  matches = c(84248, 158150),
  token = "yourToken"
)
}
}
