% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewFactorialSchurPol.R
\name{SkewFactorialSchurPol}
\alias{SkewFactorialSchurPol}
\title{Skew factorial Schur polynomial}
\usage{
SkewFactorialSchurPol(n, lambda, mu, a, i0)
}
\arguments{
\item{n}{number of variables}

\item{lambda, mu}{integer partitions defining the skew partition:
\code{lambda} is the outer partition and \code{mu} is the inner partition
(so \code{mu} must be a subpartition of \code{lambda})}

\item{a}{vector of \code{bigq} numbers, or vector of elements coercible
to \code{bigq} numbers; this vector corresponds to the sequence denoted by
\eqn{a} in the
\href{https://www.kurims.kyoto-u.ac.jp/EMIS/journals/SLC/opapers/s28macdonald.pdf}{reference paper},
section \strong{6th Variation} (in this paper \eqn{a} is a doubly
infinite sequence, but only a finite number of indices are not involved);
the length of this vector must be large enough (an error will be thrown
if it is too small) but it is not easy to know the minimal possible length}

\item{i0}{positive integer, the index of \code{a} that must be considered
as the zero index of the sequence denoted by \eqn{a} in the reference
paper}
}
\value{
A \code{qspray} polynomial.
}
\description{
Computes the skew factorial Schur polynomial associated to a
  given skew partition.
}
\examples{
# for a=c(0, 0, ...), the skew factorial Schur polynomial is the
# skew Schur polynomial; let's check
n <- 4
lambda <- c(3, 3, 2, 2); mu <- c(2, 2)
a <- rep(0, 9)
i0 <- 3
skewFactorialSchurPoly <- SkewFactorialSchurPol(n, lambda, mu, a, i0)
skewSchurPoly <- SkewSchurPol(n, lambda, mu)
skewFactorialSchurPoly == skewSchurPoly # should be TRUE
}
\references{
I.G. Macdonald.
\emph{Schur functions: theme and variations}.
Publ. IRMA Strasbourg, 1992.
}
