% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set_parents}
\alias{set_parents}
\title{Set parents for samples}
\usage{
set_parents(tables, parents, unset_missing = FALSE)
}
\arguments{
\item{tables}{A list of tables (samples, phylogeny, compositions, ranks)}

\item{parents}{A named list of parents for each sample. Keys are the samples
and values are their new parents}

\item{unset_missing}{If TRUE, unset the parent for samples that are not in
the parent list}
}
\value{
A list of tables with parents set for each sample
}
\description{
Given a list of jellyfish input tables and a named list of parents for each
sample, set the parent for each sample.
}
\details{
By default, all samples that have no explicit parent are children of the
\emph{inferred root} sample. You can customize the parent-child relationships by
modifying the \code{parent} column in the \code{samples} data frame before plotting.

You can also modify the relationships using the \code{set_parents} function.

For example, if you have three samples, A, B, and C, they will have the
following relationships by default:

\if{html}{\out{<div class="sourceCode">}}\preformatted{    Root
   / | \\
  A  B  C
}\if{html}{\out{</div>}}

With the explicit parents, you can customize the relationships:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{tables |>
  set_parents(list(
    # The parent of C is B
    C = "B"
  ) |>
  jellyfisher()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{    Root
   /  \\
  A    B
        \\
         C
}\if{html}{\out{</div>}}
}
\examples{
jellyfisher_example_tables |>
  select_patients("EOC809") |>
  set_parents(list("EOC809_r1Bow1_DNA1" = "EOC809_p2Per1_cO_DNA2")) |>
  jellyfisher()

}
