% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_summary.R
\name{table_summary}
\alias{table_summary}
\title{Summarize and Display a Two-Column Data Frame as a Formatted Table}
\usage{
table_summary(
  data,
  title = NULL,
  l = NULL,
  header = FALSE,
  center_table = FALSE,
  border_char = "-",
  style = list(),
  align = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame with exactly two columns. The data to be summarized and displayed.}

\item{title}{A character string. An optional title to be displayed above the table.}

\item{l}{An integer. The number of rows to include in the left part of a split table.
If \code{NULL}, the table is not split.}

\item{header}{A logical value. If \code{TRUE}, the column names of \code{data} are displayed as a header.}

\item{center_table}{A logical value. If \code{TRUE}, the table is centered in the terminal.}

\item{border_char}{Character used for borders. Default is \code{"\\u2500"}.}

\item{style}{A list controlling the visual styling of table elements using ANSI formatting.
Can include the following components:
\itemize{
\item \code{left_col}: Styling for the left column values.
\item \code{right_col}: Styling for the right column values.
\item \code{border_text}: Styling for the border.
\item \code{title}: Styling for the title.
\item \code{sep}: Separator character between left and right column.
}

Each style component can be either a predefined style string (e.g., "blue", "red_italic", "bold")
or a function that takes a context list with/without a \code{value} element and returns the styled text.}

\item{align}{Controls the alignment of column values.
Can be specified in three ways:
\itemize{
\item A single string: affects only the left column (e.g., "left", "center", "right").
\item A vector of two strings: affects both columns in order (e.g., c("left", "right")).
\item A list with named components: explicitly specifies alignment for each column
}}

\item{...}{Additional arguments (currently unused).}
}
\value{
This function does not return a value. It prints the formatted table to the console.
}
\description{
This function takes a two-column data frame and formats it into a summary-like table.
The table can be optionally split into two parts, centered, and given a title.
It is useful for displaying summary information in a clean, tabular format.
The function also supports styling with ANSI colors and text formatting through
the \code{{cli}} package and column alignment options.
}
\examples{
# Create a sample data frame
df = data.frame(
    Category = c("A", "B", "C", "D", "E"),
    Value = c(10, 20, 30, 40, 50)
)

# Display the table with a title and header
table_summary(df, title = "Sample Table", header = TRUE)

# Split the table after the second row and center it
table_summary(df, l = 2, center_table = TRUE)

# Use styling and alignment
table_summary(
    df, header = TRUE,
    style = list(
        left_col = "blue_bold",
        right_col = "red",
        title = "green",
        border_text = "yellow"
    ),
    align = c("center", "right")
)

# Use custom styling with lambda functions
table_summary(
    df, header = TRUE,
    style = list(
        left_col = \(ctx) cli::col_red(ctx), # ctx$value is another option
        right_col = \(ctx) cli::col_blue(ctx)
    ),
    align = list(left_col = "left", right_col = "right")
)

}
