% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stats.R
\name{getStatsIntervals}
\alias{getStatsIntervals}
\title{Compute credible intervals for rhythm or differential rhythm statistics}
\usage{
getStatsIntervals(posteriorStats, mass = 0.9, method = c("eti", "hdi"))
}
\arguments{
\item{posteriorStats}{A \code{data.table} of statistics for posterior samples, as
returned by \code{\link[=getRhythmStats]{getRhythmStats()}} or \code{\link[=getDiffRhythmStats]{getDiffRhythmStats()}}.}

\item{mass}{Number between 0 and 1 indicating the probability mass for which
to calculate the intervals.}

\item{method}{String indicating the type of interval: 'eti' for equal-tailed
using \code{\link[stats:quantile]{stats::quantile()}}, or 'hdi' for highest density using
\code{\link[HDInterval:hdi]{HDInterval::hdi()}}.}
}
\value{
A \code{data.table} containing lower and upper bounds of various
statistics for each feature or each feature-condition pair. For
\code{peak_trough_amp} and \code{rms_amp}, a negative lower bound indicates a rhythm
of the opposite phase.
}
\description{
This function uses posterior samples to quantify uncertainty in the
properties of fitted curves.
}
\examples{
library('data.table')

y = GSE54650$y
metadata = GSE54650$metadata

fit = getModelFit(y, metadata)
fit = getPosteriorFit(fit)
fit = getPosteriorSamples(fit, nPosteriorSamples = 10L)

rhyStatsSamps = getRhythmStats(
  fit, features = c('13170', '13869'), fitType = 'posterior_samples')
rhyStatsInts = getStatsIntervals(rhyStatsSamps)
}
\seealso{
\code{\link[=getRhythmStats]{getRhythmStats()}}, \code{\link[=getDiffRhythmStats]{getDiffRhythmStats()}},
\code{\link[=getExpectedMeasIntervals]{getExpectedMeasIntervals()}}
}
