% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linconGauss.R
\name{linconGauss}
\alias{linconGauss}
\title{Sample Gaussian distribution with linear constraints
Taking truncated sample of Gaussian distribution over a linear constraint domain.}
\usage{
linconGauss(
  n,
  A,
  b,
  Sigma,
  mu,
  x_init = NULL,
  intersection = TRUE,
  n_retry_init = 1000,
  nskp = 5
)
}
\arguments{
\item{n}{number of samples to take}

\item{A}{a matrix with M by D dimensions, the linear constraints, such that Ax+b>=0}

\item{b}{the offset of the linear constraints with dimension M such that Ax+b>=0}

\item{Sigma}{covariance matrix of the Gaussian}

\item{mu}{mean vector of the Gaussian}

\item{x_init}{the sample to start with, if NULL, a sample will be drawn using rejection method}

\item{intersection}{bool whether sample from the intersection or the union of the linear constraints, default true, sample from the intersection}

\item{n_retry_init}{how many times to try finding a initial value}

\item{nskp}{how many sample to skip during the sampling routine}
}
\value{
a matrix with truncated sample, row as samples
}
\description{
Sample Gaussian distribution with linear constraints
Taking truncated sample of Gaussian distribution over a linear constraint domain.
}
\examples{
my_sample <- linconGauss(100, diag(2),c(0,0),diag(2),c(0,0))
MASS_sample <- MASS::mvrnorm(1000,c(0,0),diag(2))
plot(MASS_sample)
points(my_sample,col = "red")
abline(h=0)
abline(v=0)

}
