% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_mappoly_csv.R
\name{read_geno_csv}
\alias{read_geno_csv}
\title{Data Input in CSV format}
\usage{
read_geno_csv(
  file.in,
  ploidy,
  filter.non.conforming = TRUE,
  elim.redundant = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{file.in}{a character string with the name of (or full path to) the input file 
containing the data to be read}

\item{ploidy}{the ploidy level}

\item{filter.non.conforming}{if \code{TRUE} (default) converts data points with unexpected 
genotypes (i.e. no double reduction) to 'NA'. See function \code{\link[mappoly]{segreg_poly}} 
for information on expected classes and their respective frequencies.}

\item{elim.redundant}{logical. If \code{TRUE} (default), removes redundant markers
during map construction, keeping them annotated to export to the final map.}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}
}
\value{
An object of class \code{mappoly.data} which contains a
    list with the following components:
    \item{ploidy}{ploidy level}
    \item{n.ind}{number individuals}
    \item{n.mrk}{total number of markers}
    \item{ind.names}{the names of the individuals}
    \item{mrk.names}{the names of the markers}
    \item{dosage.p1}{a vector containing the dosage in
      parent P for all \code{n.mrk} markers}
    \item{dosage.p2}{a vector containing the dosage in
      parent Q for all \code{n.mrk} markers}
    \item{chrom}{a vector indicating which sequence each marker
      belongs. Zero indicates that the marker was not assigned to any
      sequence}
    \item{genome.pos}{Physical position of the markers into the
      sequence}
    \item{seq.ref}{NULL (unused in this type of data)}
    \item{seq.alt}{NULL (unused in this type of data)}
    \item{all.mrk.depth}{NULL (unused in this type of data)}
    \item{geno.dose}{a matrix containing the dosage for each markers (rows) 
      for each individual (columns). Missing data are represented by 
      \code{ploidy_level + 1}}
    \item{n.phen}{number of phenotypic traits}
    \item{phen}{a matrix containing the phenotypic data. The rows
                correspond to the traits and the columns correspond
                to the individuals}
    \item{kept}{if elim.redundant = TRUE, holds all non-redundant markers}
    \item{elim.correspondence}{if elim.redundant = TRUE, holds all non-redundant markers and
its equivalence to the redundant ones}
}
\description{
Reads an external comma-separated values (CSV) data file. The format of the file is described in the \code{Details}
section. This function creates an object of class \code{mappoly.data}.
}
\details{
This is an alternative and a somewhat more straightforward version of the function 
 \code{\link[mappoly]{read_geno}}. The input is a standard CSV file where the rows 
 represent the markers, except for the first row which is used as a header. 
 The first five columns contain the marker names, the dosage in parents 1 and 2, 
 the chromosome information (i.e. chromosome,  scaffold, contig, etc) and the 
 position of the marker within the sequence. The remaining columns contain 
 the dosage of the full-sib population. A tetraploid example of such file 
 can be found in the \code{Examples} section.
}
\examples{
\donttest{
#### Tetraploid Example
ft = "https://raw.githubusercontent.com/mmollina/MAPpoly_vignettes/master/data/tetra_solcap.csv"
tempfl <- tempfile()
download.file(ft, destfile = tempfl)
SolCAP.dose <- read_geno_csv(file.in  = tempfl, ploidy = 4)
print(SolCAP.dose, detailed = TRUE)
plot(SolCAP.dose)
}
}
\references{
Mollinari M., Olukolu B. A.,  Pereira G. da S., 
    Khan A., Gemenet D., Yencho G. C., Zeng Z-B. (2020), 
    Unraveling the Hexaploid Sweetpotato Inheritance 
    Using Ultra-Dense Multilocus Mapping, 
    _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400620} 
    
    Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}, with minor changes by Gabriel Gesteira, \email{gdesiqu@ncsu.edu}
}
