% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_and_rephase.R
\name{split_and_rephase}
\alias{split_and_rephase}
\title{Divides map in sub-maps and re-phase them}
\usage{
split_and_rephase(
  input.map,
  twopt,
  gap.threshold = 5,
  size.rem.cluster = 1,
  phase.config = "best",
  thres.twopt = 3,
  thres.hmm = "best",
  tol.merge = 0.001,
  tol.final = 0.001,
  verbose = TRUE
)
}
\arguments{
\item{input.map}{an object of class \code{mappoly.map}}

\item{twopt}{an object of class \code{mappoly.twopt}
containing the two-point information for the markers contained 
in \code{input.map}}

\item{gap.threshold}{distance threshold of neighboring markers 
where the map should be spitted. The default 
value is 5 cM}

\item{size.rem.cluster}{the size of the marker cluster (in number of markers) 
from which the cluster should be removed. The default 
value is 1}

\item{phase.config}{which phase configuration should be used. "best" (default) 
will choose the maximum likelihood phase configuration}

\item{thres.twopt}{the threshold used to determine if the linkage
phases compared via two-point analysis should be considered 
for the search space reduction (default = 3)}

\item{thres.hmm}{the threshold used to determine which linkage 
phase configurations should be returned when merging two maps.
If "best" (default), returns only the best linkage phase 
configuration. NOTE: if merging multiple maps, it always uses 
the "best" linkage phase configuration at each block insertion.}

\item{tol.merge}{the desired accuracy for merging maps (default = 10e-04)}

\item{tol.final}{the desired accuracy for the final map (default = 10e-04)}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}
}
\value{
An object of class \code{mappoly.map}
}
\description{
The function splits the input map in sub-maps 
given a distance threshold of neighboring markers 
and evaluates alternative phases between the sub-maps.
}
\examples{
 map <- get_submap(solcap.dose.map[[1]], 1:20, verbose = FALSE)
 tpt <- est_pairwise_rf(make_seq_mappoly(map))
 new.map <- split_and_rephase(map, tpt, 1, 1)
 map
 new.map
 plot_map_list(list(old.map = map, new.map = new.map), col = "ggstyle")

}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
