/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.IPretty;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBool;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.set.AbstractLargeSetIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetDomain;
import choco.kernel.solver.variables.set.SetVar;

public abstract class AbstractBoundOfASet
extends AbstractLargeSetIntSConstraint {
    public static final int SET_INDEX = 0;
    public static final int BOUND_INDEX = 0;
    public static final int VARS_OFFSET = 1;
    private final EmptySetPolicy emptySetPolicy;
    private final IStateBool awakeOnFirstKer;
    private IStateInt indexOfMinimumVariable;

    public AbstractBoundOfASet(IEnvironment environment, IntDomainVar[] intvars, SetVar setvar, EmptySetPolicy emptySetPolicy) {
        super(intvars, new SetVar[]{setvar});
        this.emptySetPolicy = emptySetPolicy;
        this.awakeOnFirstKer = environment.makeBool(true);
        this.indexOfMinimumVariable = environment.makeInt(-1);
        if (setvar.getEnveloppeDomainSize() > 0 && (setvar.getEnveloppeInf() < 0 || setvar.getEnveloppeSup() > intvars.length - 2)) {
            throw new SolverException("The enveloppe of the set variable " + setvar.pretty() + " is greater than the array");
        }
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return idx > 0 ? 11 : 7;
    }

    protected final boolean isInKernel(int idx) {
        return this.svars[0].isInDomainKernel(idx);
    }

    protected final boolean isInEnveloppe(int idx) {
        return this.svars[0].isInDomainEnveloppe(idx);
    }

    protected final SetDomain getSetDomain() {
        return this.svars[0].getDomain();
    }

    protected final boolean isEmptySet() {
        return this.svars[0].getEnveloppeDomainSize() == 0;
    }

    protected final boolean isNotEmptySet() {
        return this.svars[0].getKernelDomainSize() > 0;
    }

    protected final boolean isSetInstantiated() {
        return this.svars[0].isInstantiated();
    }

    protected final boolean updateBoundInf(int val) throws ContradictionException {
        return this.ivars[0].updateInf(val, this, false);
    }

    protected final boolean updateBoundSup(int val) throws ContradictionException {
        return this.ivars[0].updateSup(val, this, false);
    }

    protected abstract boolean removeFromEnv(int var1) throws ContradictionException;

    protected final boolean removeGreaterFromEnv(int idx, int maxValue) throws ContradictionException {
        return this.ivars[1 + idx].getInf() > maxValue && this.svars[0].remFromEnveloppe(idx, this, false);
    }

    protected final boolean removeLowerFromEnv(int idx, int minValue) throws ContradictionException {
        return this.ivars[1 + idx].getSup() < minValue && this.svars[0].remFromEnveloppe(idx, this, false);
    }

    protected final boolean remFromEnveloppe() throws ContradictionException {
        DisposableIntIterator iter = this.getSetDomain().getOpenDomainIterator();
        boolean update = false;
        while (iter.hasNext()) {
            update |= this.removeFromEnv(iter.next());
        }
        iter.dispose();
        return update;
    }

    @Override
    public final void awakeOnEnvRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        assert (idx == 0);
        if (deltaDomain.hasNext()) {
            this.awakeOnRem();
        }
    }

    @Override
    public final void awakeOnRem(int varIdx, int val) throws ContradictionException {
        assert (varIdx == 0);
        this.awakeOnRem();
    }

    protected abstract void awakeOnRem() throws ContradictionException;

    @Override
    public final void awakeOnkerAdditions(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        assert (idx == 0);
        if (deltaDomain.hasNext()) {
            if (this.awakeOnFirstKer.get()) {
                this.propagate();
                this.awakeOnFirstKer.set(false);
            } else {
                this.awakeOnKer();
            }
        }
    }

    @Override
    public final void awakeOnKer(int varIdx, int x) throws ContradictionException {
        assert (varIdx == 0);
        if (this.awakeOnFirstKer.get()) {
            this.propagate();
            this.awakeOnFirstKer.set(false);
        } else {
            this.awakeOnKer();
        }
    }

    protected abstract void awakeOnKer() throws ContradictionException;

    @Override
    public boolean isConsistent() {
        return false;
    }

    @Override
    public final void propagate() throws ContradictionException {
        if (this.isEmptySet()) {
            switch (this.emptySetPolicy) {
                case INF: {
                    this.ivars[0].instantiate(this.ivars[0].getInf(), this, false);
                    break;
                }
                case SUP: {
                    this.ivars[0].instantiate(this.ivars[0].getSup(), this, false);
                    break;
                }
            }
            this.setEntailed();
        } else {
            this.filter();
        }
    }

    protected abstract void filter() throws ContradictionException;

    @Override
    public final void awakeOnInst(int idx) throws ContradictionException {
        if (idx >= 2) {
            int i = idx - 2;
            if (this.isInEnveloppe(i)) {
                this.propagate();
            }
        } else {
            this.propagate();
        }
    }

    protected abstract int updateIndexOfCandidateVariable();

    protected void onlyOneCandidatePropagation() throws ContradictionException {
        if (this.isNotEmptySet()) {
            int idx = this.indexOfMinimumVariable.get();
            if (idx == -1) {
                idx = this.updateIndexOfCandidateVariable();
            }
            if (idx != -1) {
                this.indexOfMinimumVariable.set(idx);
                this.svars[0].addToKernel(idx - 1, this, false);
                this.updateBoundInf(this.ivars[idx].getInf());
                this.updateBoundSup(this.ivars[idx].getSup());
                this.ivars[idx].updateInf(this.ivars[0].getInf(), this, false);
                this.ivars[idx].updateSup(this.ivars[0].getSup(), this, false);
            }
        }
    }

    protected abstract int getSatisfiedValue(DisposableIntIterator var1);

    @Override
    public boolean isSatisfied() {
        return this.isNotEmptySet() ? this.getSatisfiedValue(this.svars[0].getDomain().getKernelIterator()) == this.ivars[0].getVal() : true;
    }

    protected String pretty(String name) {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.ivars[0].pretty());
        sb.append(" = ").append(name).append('(');
        sb.append(this.svars[0].pretty()).append(", ");
        sb.append(StringUtils.pretty((IPretty[])this.ivars, 1, this.ivars.length));
        sb.append(", Policy:").append((Object)this.emptySetPolicy);
        sb.append(')');
        return new String(sb);
    }

    public static enum EmptySetPolicy {
        INF,
        NONE,
        SUP;

    }
}

