% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_inputs.R
\name{check_inputs}
\alias{check_inputs}
\alias{check_topography}
\alias{check_land_cover}
\alias{check_forests}
\alias{check_soils}
\title{Check spatial inputs}
\usage{
check_topography(
  x,
  missing_action = "no_action",
  default_values = c(elevation = 0, slope = NA, aspect = NA),
  verbose = TRUE
)

check_land_cover(
  x,
  missing_action = "no_action",
  default_values = "wildland",
  verbose = TRUE
)

check_forests(
  x,
  SpParams = NULL,
  missing_action = "no_action",
  default_forest = NULL,
  progress = FALSE,
  verbose = TRUE
)

check_soils(
  x,
  check_equal_layers = FALSE,
  missing_action = "no_action",
  default_values = c(clay = 25, sand = 25, bd = 1.5, rfc = 25),
  progress = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{An object of class \code{\link[sf]{sf}} to be checked.}

\item{missing_action}{Action to perform for missing values, either "no_action" (for checks), "filter" (filter missing data), "default" (impute default values)}

\item{default_values}{Vector of default values for locations with missing data.}

\item{verbose}{Logical flag to indicate extra console output.}

\item{SpParams}{A data frame with species parameters (see \code{\link[medfate]{SpParamsMED}}).}

\item{default_forest}{Default \code{\link[medfate]{forest}} object to fill locations where missing (e.g. \code{default_forest = medfate::emptyforest()}).}

\item{progress}{A logical flag to print information about progress.}

\item{check_equal_layers}{Logical flag to test whether soils have the same number of layers.}
}
\value{
All functions return a modified \code{\link[sf]{sf}} object if \code{missing_action} is either \code{"filter"} or \code{"default"}. Otherwise,
they return an invisible tibble with logical columns indicating where missing information is. In \code{check_forests()} the function will return a modified object if
parameter \code{default_forest} is provided.
}
\description{
Functions to check and correct spatial inputs for simulations
}
\details{
Function \code{check_topography()} checks that columns \code{"elevation"}, \code{"slope"} and \code{"aspect"} do not contain missing values.

Function \code{check_land_cover()} checks that column \code{"land_cover_type"} does not contain missing values.

Function \code{check_forests()} checks first that \code{\link[medfate]{forest}} objects are defined in "wildland" locations. Then, it looks for missing
data in tree or shrub attributes required for simulations. If \code{SpParams} is provided, the function also checks
whether species names are within the taxa represented in \code{SpParams}. If \code{default_forest} is provided, the function will use it to fill locations with missing forests objects.

Function \code{check_soils()} checks first that "wildland" and "agriculture" locations have a defined soil object. Then it looks for missing data in required
soil physical parameters.
}
\examples{
data(example_ifn)

check_topography(example_ifn)
check_land_cover(example_ifn)
check_forests(example_ifn)
check_soils(example_ifn)
}
