% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vartymetric.R
\name{gpd.boot}
\alias{gpd.boot}
\title{Bootstrap approximation for generalized Pareto parameters}
\usage{
gpd.boot(object, B = 1000L, method = c("post", "norm"))
}
\arguments{
\item{object}{object of class \code{mev_gpd}}

\item{B}{number of pairs to sample}

\item{method}{string; one of \code{'norm'} for the
normal approximation or \code{'post'} (default) for posterior sampling}
}
\value{
a matrix of size B by 2 whose columns contain scale and shape parameters
}
\description{
Given an object of class \code{mev_gpd},
returns a matrix of parameter values to mimic
the estimation uncertainty.
}
\details{
Two options are available: a normal approximation to
the scale and shape based on the maximum likelihood
estimates and the observed information matrix.
This method uses forward sampling to simulate
from a bivariate normal distribution that satisfies
the support and positivity constraints

The second approximation uses the ratio-of-uniforms
method to obtain samples from the posterior
distribution with uninformative priors, thus
mimicking the joint distribution of maximum likelihood.
The benefit of the latter is that it is more reliable
in small samples and when the shape is negative.
}
