% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lthill.R
\name{tstab.lthill}
\alias{tstab.lthill}
\title{Threshold stability plots for left-truncated Hill estimators}
\usage{
tstab.lthill(xdat, k, which = c("lthill", "var", "slope"), log = TRUE, ...)
}
\arguments{
\item{xdat}{[numeric] vector of positive observations}

\item{k}{[integer] number of order statistics for the threshold}

\item{which}{[string] the type of plot, showing the left-truncated Hill plot on the log, the log of the variance of the estimator, or the log slope}

\item{log}{[logical] if \code{TRUE} (default), shows the Hill plot on the log-scale}

\item{...}{additional parameters for color, etc. to be passed to plot}
}
\value{
an invisible list with lthill, order statistics, the log variance and the log scale.
}
\description{
Given a vector of exceedances and some potential choices of \eqn{k} for the threshold, compute the left-truncated Hill estimators for each value of \code{k} and use these to compute the variance and slope of the estimator
}
\examples{
xdat <- 10/(1 - runif(n = 1000)) - 10
tstab.lthill(xdat = xdat, k = c(50,100,200))
}
\references{
Bladt, M., Albrecher, H. & Beirlant, J. (2020) \emph{Threshold selection and trimming in extremes}. Extremes, 23, 629-665 . \doi{10.1007/s10687-020-00385-0}
}
