% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpca_clustering.R
\encoding{UTF-8}
\name{vpca_clustering}
\alias{vpca_clustering}
\title{Performs the fuzzy clustering algorithm of He and Tan (2020).}
\usage{
vpca_clustering(
  X,
  k,
  m,
  var_rate = 0.9,
  max_it = 1000,
  tol = 1e-05,
  crisp = FALSE
)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{k}{The number of clusters.}

\item{m}{The fuzziness coefficient (a real number greater than one).}

\item{var_rate}{Rate of retained variability concerning the
dimensionality-reduced MTS samples (default is 0.90).}

\item{max_it}{The maximum number of iterations (default is 1000).}

\item{tol}{The tolerance (default is 1e-5).}

\item{crisp}{Logical. If \code{crisp = FALSE} (default) a fuzzy partition
is returned. Otherwise, the function returns the corresponding crisp
partition, in which each series is placed in the cluster associated
with the maximum membership degree.}
}
\value{
A list with three elements:
\itemize{
\item \code{U}. If \code{crisp = FALSE} (default), the membership matrix. Otherwise,
a vector defining the corresponding crisp partition.
\item \code{centroids}. If \code{crisp = FALSE} (default), a list containing the
series playing the role of centroids, which are dimensionality-reduced averaged MTS. Otherwise, this
element is not returned.
\item \code{iterations}. The number of iterations before the algorithm
stopped.
}
}
\description{
\code{vpca_clustering} performs the fuzzy clustering algorithm proposed
by \insertCite{he2018unsupervised;textual}{mlmts}.
}
\details{
This function executes the fuzzy clustering procedure proposed by
. The algorithm represents each MTS in the original collection by means of
a dimensionality-reduced MTS constructed through variable-based principal
component analysis (VPCA). Then, fuzzy \eqn{K}-means-type procedure is considered
for the set of dimensionalityu-reduced samples. A spatial weighted matrix
dissimilarity is considered to compute the distances between the reduced
MTS and the centroids.
}
\examples{
fuzzy_clustering <- vpca_clustering(AtrialFibrillation$data, k = 3, m = 1.5)
# Executing the fuzzy clustering algorithm in the dataset AtrialFibrillation
# by considering 3 clusters and a value of 1.5 for the fuziness parameter
fuzzy_clustering$U # The membership matrix
crisp_clustering <- vpca_clustering(AtrialFibrillation$data, k = 3, m = 1.5, crisp = TRUE)
# The same as before, but we are interested in the corresponding crisp partition
crisp_clustering$U # The crisp partition
crisp_clustering$iterations # The number of iterations before the algorithm
# stopped
}
\references{
{

  \insertRef{he2018unsupervised}{mlmts}

}
}
\seealso{
\code{\link{vpca_clustering}}
}
\author{
Ángel López-Oriona, José A. Vilar
}
