% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloset_base.R
\name{sTXI}
\alias{sTXI}
\title{Calculate Stratum-Specific Transcriptomic Index}
\usage{
sTXI(phyex_set, option = "identity")
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object}

\item{option}{Character string specifying calculation method:
- "identity": Sum pTXI values within each stratum
- "add": Cumulative sum across strata}
}
\value{
Matrix of sTXI values with strata as rows and identities as columns
}
\description{
Calculate the stratum-specific transcriptomic index (sTXI) by summing pTXI values within each phylostratum.
}
\examples{
# Calculate sTXI values
stxi_values <- sTXI(example_phyex_set, option = "identity")
stxi_cumsum <- sTXI(example_phyex_set, option = "add")

}
