% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFDataset.R
\docType{class}
\name{CFDataset}
\alias{CFDataset}
\title{CF data set}
\description{
This class represents a CF data set, the object that
encapsulates a netCDF resource. You should never instantiate this class
directly; instead, call \code{\link[=open_ncdf]{open_ncdf()}} which will return an instance that
has all properties read from the netCDF resource, or \code{\link[=create_ncdf]{create_ncdf()}} for a
new, empty instance. Class methods can then be called, or the base R
functions called with this instance.

The CF data set instance provides access to all the objects in the netCDF
resource, organized in groups.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{The name of the netCDF resource. This is extracted from the
URI (file name or URL).}

\item{\code{root}}{Root of the group hierarchy through which all elements of the
netCDF resource are accessed. It is \strong{strongly discouraged} to
manipulate the objects in the group hierarchy directly. Use the provided
access methods instead.}

\item{\code{file_type}}{The type of data in the netCDF resource, if
identifiable. In terms of the CF Metadata Conventions, this includes
discrete sampling geometries (DSG). Other file types that can be
identified include L3b files used by NASA and NOAA for satellite
imagery (these data sets need special processing), and CMIP5, CMIP6 and
CORDEX climate projection data.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}

\item{\code{resource}}{(read-only) The connection details of the netCDF
resource. This is for internal use only.}

\item{\code{uri}}{(read-only) The connection string to the netCDF resource.}

\item{\code{conventions}}{(read-only) Returns the conventions that this netCDF
resource conforms to.}

\item{\code{var_names}}{(read-only) Vector of names of variables in this data set.}

\item{\code{axis_names}}{(read-only) Vector of names of axes in this data set.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFDataset-new}{\code{CFDataset$new()}}
\item \href{#method-CFDataset-print}{\code{CFDataset$print()}}
\item \href{#method-CFDataset-hierarchy}{\code{CFDataset$hierarchy()}}
\item \href{#method-CFDataset-objects_by_standard_name}{\code{CFDataset$objects_by_standard_name()}}
\item \href{#method-CFDataset-has_subgroups}{\code{CFDataset$has_subgroups()}}
\item \href{#method-CFDataset-find_by_name}{\code{CFDataset$find_by_name()}}
\item \href{#method-CFDataset-variables}{\code{CFDataset$variables()}}
\item \href{#method-CFDataset-axes}{\code{CFDataset$axes()}}
\item \href{#method-CFDataset-attributes}{\code{CFDataset$attributes()}}
\item \href{#method-CFDataset-attribute}{\code{CFDataset$attribute()}}
\item \href{#method-CFDataset-set_attribute}{\code{CFDataset$set_attribute()}}
\item \href{#method-CFDataset-append_attribute}{\code{CFDataset$append_attribute()}}
\item \href{#method-CFDataset-delete_attribute}{\code{CFDataset$delete_attribute()}}
\item \href{#method-CFDataset-add_variable}{\code{CFDataset$add_variable()}}
\item \href{#method-CFDataset-save}{\code{CFDataset$save()}}
\item \href{#method-CFDataset-clone}{\code{CFDataset$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-new}{}}}
\subsection{Method \code{new()}}{
Create an instance of this class. Do not instantiate this
class directly; instead, call \code{\link[=open_ncdf]{open_ncdf()}} which will return an
instance that has all properties read from the netCDF resource, or
\code{\link[=create_ncdf]{create_ncdf()}} for a new, empty instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$new(resource, format)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{An instance of \code{NCResource} that links to the netCDF
resource, or a character string with the name of a new data set.}

\item{\code{format}}{Character string with the format of the netCDF resource as
reported by the call opening the resource. Ignored when argument
\code{resource} is a character string.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-print"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-print}{}}}
\subsection{Method \code{print()}}{
Summary of the data set printed to the console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments passed on to other functions. Of particular interest
is \verb{width = } to indicate a maximum width of attribute columns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-hierarchy"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-hierarchy}{}}}
\subsection{Method \code{hierarchy()}}{
Print the group hierarchy to the console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$hierarchy()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-objects_by_standard_name"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-objects_by_standard_name}{}}}
\subsection{Method \code{objects_by_standard_name()}}{
Get objects by standard_name. Several conventions define
standard vocabularies for physical properties. The standard names from
those vocabularies are usually stored as the "standard_name" attribute
with variables or axes. This method retrieves all variables or axes
that list the specified "standard_name" in its attributes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$objects_by_standard_name(standard_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{standard_name}}{Optional, a character string to search for a
specific "standard_name" value in variables and axes.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If argument \code{standard_name} is provided, a character vector of
variable or axis names. If argument \code{standard_name} is missing or an
empty string, a named list with all "standard_name" attribute values in
the the netCDF resource; each list item is named for the variable or
axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-has_subgroups"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-has_subgroups}{}}}
\subsection{Method \code{has_subgroups()}}{
Does the netCDF resource have subgroups? Newer versions of
the \code{netcdf} library, specifically \code{netcdf4}, can organize dimensions
and variables in groups. This method will report if the data set is
indeed organized with subgroups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$has_subgroups()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical to indicate that the netCDF resource uses subgroups.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-find_by_name"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-find_by_name}{}}}
\subsection{Method \code{find_by_name()}}{
Find an object by its name. Given the name of a CF data
variable or axis, possibly preceded by an absolute group path, return
the object to the caller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$find_by_name(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of a CF data variable or axis, with an optional
absolute group path.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The object with the provided name. If the object is not found,
returns \code{NULL}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-variables"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-variables}{}}}
\subsection{Method \code{variables()}}{
This method lists the CF data variables located in this
netCDF resource, including those in subgroups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$variables()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \code{CFVariable} instances.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-axes"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-axes}{}}}
\subsection{Method \code{axes()}}{
This method lists the axes located in this netCDF resource,
including axes in subgroups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$axes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \code{CFAxis} descendants.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-attributes"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-attributes}{}}}
\subsection{Method \code{attributes()}}{
List all the attributes of a group. This method returns a
\code{data.frame} containing all the attributes of the indicated \code{group}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$attributes(group)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{The name of the group whose attributes to return. If the
argument is missing, the global attributes will be returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.frame} of attributes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-attribute"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-attribute}{}}}
\subsection{Method \code{attribute()}}{
Retrieve global attributes of the data set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$attribute(att, field = "value")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{att}}{Vector of character strings of attributes to return.}

\item{\code{field}}{The field of the attribute to return values from. This must
be "value" (default) or "type".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If the \code{field} argument is "type", a character string. If \code{field}
is "value", a single value of the type of the attribute, or a vector
when the attribute has multiple values. If no attribute is named with a
value of argument \code{att} \code{NA} is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-set_attribute"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-set_attribute}{}}}
\subsection{Method \code{set_attribute()}}{
Add an attribute to the global attributes. If an attribute
\code{name} already exists, it will be overwritten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$set_attribute(name, type, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the attribute. The name must begin with a letter
and be composed of letters, digits, and underscores, with a maximum
length of 255 characters. UTF-8 characters are not supported in
attribute names.}

\item{\code{type}}{The type of the attribute, as a string value of a netCDF data
type.}

\item{\code{value}}{The value of the attribute. This can be of any supported
type, including a vector or list of values. Matrices, arrays and like
compound data structures should be stored as a data variable, not as an
attribute and they are thus not allowed. In general, an attribute
should be a character value, a numeric value, a logical value, or a
short vector or list of any of these. Values passed in a list will be
coerced to their common mode.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-append_attribute"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-append_attribute}{}}}
\subsection{Method \code{append_attribute()}}{
Append the text value of a global attribute. If an attribute
\code{name} already exists, the \code{value} will be appended to the existing
value of the attribute. If the attribute \code{name} does not exist it will
be created. The attribute must be of "NC_CHAR" or "NC_STRING" type; in
the latter case having only a single string value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$append_attribute(name, value, sep = "; ", prepend = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the attribute. The name must begin with a letter
and be composed of letters, digits, and underscores, with a maximum
length of 255 characters. UTF-8 characters are not supported in
attribute names.}

\item{\code{value}}{The character value of the attribute to append. This must be
a character string.}

\item{\code{sep}}{The separator to use. Default is \code{"; "}.}

\item{\code{prepend}}{Logical to flag if the supplied \code{value} should be placed
before the existing value. Default is \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-delete_attribute"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-delete_attribute}{}}}
\subsection{Method \code{delete_attribute()}}{
Delete attributes. If an attribute \code{name} is not present
this method simply returns.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$delete_attribute(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Vector of names of the attributes to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-add_variable"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-add_variable}{}}}
\subsection{Method \code{add_variable()}}{
Add a \link{CFVariable} object to the data set. If there is
another object with the same name in the group where the data variable
should be placed an error is thrown. For objects associated with the
data variable (such as axes, CRS, boundary variables, etc), if another
object with the same name is otherwise identical to the associated
object then that object will be linked from the variable, otherwise an
error is thrown.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$add_variable(var, group, locations = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{var}}{An instance of \code{CFVariable} or any of its descendants.}

\item{\code{group}}{Optional. An instance of \link{CFGroup} where the data variable
should be located. If omitted, the data variable will be stored in the
root group.}

\item{\code{locations}}{Optional. A \code{list} whose named elements correspond to
the names of objects associated with the data variable in argument
\code{var}. Each list element has a single character string indicating the
group in the hierarchy where the object should be stored. As an
example, if the data variable has axes "lon" and "lat" and they should
be stored in the parent group of \code{group}, then specify \code{locations = list(lon = "..", lat = "..")}. Locations can use absolute paths or
relative paths from the \code{group}. Associated objects that are not in the
list will be stored in \code{group}. If the argument \code{locations} is not
provided, all associated objects will be stored in \code{group}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Argument \code{var}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-save"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-save}{}}}
\subsection{Method \code{save()}}{
Save the data set to file, including its subordinate objects
such as attributes, data variables, axes, CRS, etc.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$save(fn, pack = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{Fully-qualified file name indicating where to save the data set
to. This argument must be provided if the data set is virtual. If the
argument is provided on a data set that was read from a netCDF file, a
new netCDF file will be written to the indicated location. If the
argument is missing, the existing netCDF file will be updated.}

\item{\code{pack}}{Optional. Logical to indicate if the data should be packed;
default is \code{FALSE}. Packing is only useful for numeric data; packing is
not performed on integer values. Packing is always to the "NC_SHORT"
data type, i.e. 16-bits per value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFDataset-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFDataset-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFDataset$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
