% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Effect.nestedLogit.R
\name{Effect.nestedLogit}
\alias{Effect.nestedLogit}
\title{Effect Displays for Nested Logit Models}
\usage{
\method{Effect}{nestedLogit}(
  focal.predictors,
  mod,
  confidence.level = 0.95,
  fixed.predictors = NULL,
  ...
)
}
\arguments{
\item{focal.predictors}{a character vector of the names of one or more of
the predictors in the model, for which the effect display should be computed.}

\item{mod}{a \code{"nestedLogit"} model object.}

\item{confidence.level}{for point-wise confidence bands around the effects
(the default is \code{0.95}).}

\item{fixed.predictors}{controls the values at which other predictors are fixed;
see \code{\link[effects]{Effect}} for details; if \code{NULL} (the default),
numeric predictors are set to their means, factors to their distribution in the data.}

\item{...}{optional arguments to be passed to the \code{\link[effects]{Effect}} method for
binary logit models (fit by the \code{\link{glm}} function).}
}
\value{
an object of class \code{"effpoly"} (see \code{\link[effects]{Effect}}).
}
\description{
Computes effects (in the sense of the \pkg{effects} package---see, in
particular, \code{\link[effects]{Effect}})---for \code{"nestedLogit"} models, which then
can be used with other functions in the \pkg{effects} package, for example,
\code{\link[effects]{predictorEffects}} and to produce effect plots.
}
\examples{
data("Womenlf", package = "carData")
comparisons <- logits(work=dichotomy("not.work",
                                     working=c("parttime", "fulltime")),
                      full=dichotomy("parttime", "fulltime"))
m <- nestedLogit(partic ~ hincome + children,
                   dichotomies = comparisons,
                   data=Womenlf)
peff.women <- effects::predictorEffects(m)
plot(peff.women)
plot(peff.women, axes=list(y=list(style="stacked")))
summary(peff.women)

dichots <- logits(AB_CD = dichotomy(c("A", "B"), c("C", "D")),
                  A_B   = dichotomy("A", "B"),
                  C_D   = dichotomy("C", "D"))
m.health <- nestedLogit(product4 ~ age + gender*household + position_level,
                        dichotomies = dichots, data = HealthInsurance)
eff.gen.hh <- effects::Effect(c("gender", "household"), m.health,
                              xlevels=list(household=0:7))
eff.gen.hh
plot(eff.gen.hh, axes=list(x=list(rug=FALSE)))
plot(eff.gen.hh, axes=list(x=list(rug=FALSE), 
                           y=list(style="stacked")))
}
\references{
John Fox and Sanford Weisberg (2019). \emph{An R Companion to Applied Regression},
3rd Edition. Sage, Thousand Oaks, CA.

John Fox, Sanford Weisberg (2018). Visualizing Fit and Lack of Fit in Complex
Regression Models with Predictor Effect Plots and Partial Residuals.
\emph{Journal of Statistical Software}, 87(9), 1-27.
}
\seealso{
\code{\link[effects]{Effect}}, \code{\link[effects]{plot.effpoly}},
\code{\link[effects]{predictorEffects}}
}
\author{
John Fox
}
\keyword{regression}
