% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurospace.R, R/neurovol.R
\name{coord_to_grid}
\alias{coord_to_grid}
\alias{coord_to_grid,NeuroSpace,matrix-method}
\alias{coord_to_grid,NeuroSpace,numeric-method}
\alias{coord_to_grid,NeuroVol,matrix-method}
\alias{coord_to_grid,NeuroVol,numeric-method}
\title{convert n-dimensional real world coordinates to grid coordinates}
\usage{
coord_to_grid(x, coords)

\S4method{coord_to_grid}{NeuroSpace,matrix}(x, coords)

\S4method{coord_to_grid}{NeuroSpace,numeric}(x, coords)

\S4method{coord_to_grid}{NeuroVol,matrix}(x, coords)

\S4method{coord_to_grid}{NeuroVol,numeric}(x, coords)
}
\arguments{
\item{x}{the object}

\item{coords}{a matrix of real world coordinates}
}
\value{
A numeric \code{matrix} of grid coordinates.
}
\description{
convert n-dimensional real world coordinates to grid coordinates
}
\examples{
# Create a simple 3D volume
bvol <- NeuroVol(array(0, c(10,10,10)), NeuroSpace(c(10,10,10), c(1,1,1)))
coords <- matrix(c(.5,.5,.5, 1.5,1.5,1.5), ncol=3, byrow=TRUE)
grid <- coord_to_grid(bvol, coords)
world <- grid_to_coord(bvol, grid)
all.equal(coords, world)
}
