% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_permit_events_historic.R
\name{nyc_permit_events_historic}
\alias{nyc_permit_events_historic}
\title{NYC Permitted Event Information - Historical}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/bkfu-528j>
}
\usage{
nyc_permit_events_historic(limit = 10000, filters = list(), timeout_sec = 60)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 60).}
}
\value{
A tibble containing NYC Permitted Event Information - Historical data.
}
\description{
Downloads historical permitted event data from NYC Open Data.
}
\details{
This dataset includes historical information about events permitted
through the Office of Citywide Event Coordination and Management (CECM),
including parades, festivals, street fairs, and other public gatherings.
}
\examples{
# Examples that hit the live NYC Open Data API are wrapped so CRAN checks
# do not fail when the network is unavailable or slow.
\donttest{
if (curl::has_internet()) {
  # Quick example (fetch 2 rows)
  small_sample <- nyc_permit_events_historic(limit = 2)
  small_sample

  nyc_permit_events_historic(limit = 5000)
  nyc_permit_events_historic(filters = list(event_type = "Construction"))
}
}
}
