% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_term_future_data.R
\name{long_term_future_data}
\alias{long_term_future_data}
\title{Get future predictions for the macro economic covariates}
\usage{
long_term_future_data(
  longterm_predictions,
  end_year,
  dataset = "WEO",
  data_directory = tempdir(),
  model_list = NULL
)
}
\arguments{
\item{longterm_predictions}{Dataframe or list. Generated by \code{\link{long_term_lm}}. Either the prediction dataframe or the complete output list can be used.
If the full list is supplied the function will extract the necessary models automatically.}

\item{end_year}{Integer. Specifies the final year for which future predictions will be generated.}

\item{dataset}{Character. By default the World Economic Outlook (WEO) Database April 2025 edition is used to generate covariate predictions for the long term models. If the dataset option is set to anything else than "WEO" the function will tell you for which covariates data will be needed to run \code{\link{long_term_future}}.}

\item{data_directory}{The path to the directory where the function will look for
the long-term models from \code{\link{long_term_lm}}. Only needed if dataset is not set to "WEO" and no model list is supplied.}

\item{model_list}{A list with the models from \code{\link{long_term_lm}}. Only needs to be specified if dataset is not set to "WEO" and if the models
are not in the data directory.}
}
\value{
The extended initial dataframe until the specified end year with the covariate predictions if dataset = "WEO" . Otherwise, the dataframe will have empty covariate predictions and a note for which covariates a forecast must be supplied.
}
\description{
This function gets predictions from the World Economic Outlook Database (April 2025 edition) for the covariates utilized in the long-term models. If the dataset argument is not set to "WEO",
the function will indicate which covariates require user-supplied predictions for \code{\link{long_term_future}}.
}
\examples{
example_longterm_future_macro_data <- long_term_future_data(example_longterm_predictions,
  end_year = 2028, dataset = "WEO"
)

}
