% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.datasource.R
\name{opal.variable_summary}
\alias{opal.variable_summary}
\title{Get summary statistics of a variable of a table}
\usage{
opal.variable_summary(
  opal,
  datasource,
  table,
  variable,
  cached = TRUE,
  nature = NULL
)
}
\arguments{
\item{opal}{Opal object.}

\item{datasource}{Name of the datasource.}

\item{table}{Name of the table in the datasource.}

\item{variable}{Name of the variable in the table.}

\item{cached}{Get cached summary if exists. When FALSE, the cached summary is 
evicted and replaced by the newly calculated one. Default is TRUE.}

\item{nature}{Force summary nature, independently from the variable.
Possible values are: CATEGORICAL, CONTINUOUS, TEMPORAL, GEO, BINARY, UNDETERMINED.}
}
\description{
Get summary statistics of a variable of a table
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.variable_summary(o, 'CNSIM', 'CNSIM1', 'GENDER')
opal.logout(o)
}
}
\seealso{
Other datasource functions: 
\code{\link{opal.annotate}()},
\code{\link{opal.annotations}()},
\code{\link{opal.attribute_values}()},
\code{\link{opal.datasource}()},
\code{\link{opal.datasources}()},
\code{\link{opal.table}()},
\code{\link{opal.tables}()},
\code{\link{opal.valueset}()},
\code{\link{opal.variable}()},
\code{\link{opal.variables}()}
}
\concept{datasource functions}
