% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecate.R
\name{write_data}
\alias{write_data}
\title{Defunct: Write an object to a worksheet}
\usage{
write_data(
  wb,
  sheet,
  x,
  dims = wb_dims(start_row, start_col),
  start_col = 1,
  start_row = 1,
  array = FALSE,
  col_names = TRUE,
  row_names = FALSE,
  with_filter = FALSE,
  sep = ", ",
  name = NULL,
  apply_cell_style = TRUE,
  remove_cell_style = FALSE,
  na.strings = na_strings(),
  inline_strings = TRUE,
  enforce = FALSE,
  ...
)
}
\arguments{
\item{wb}{A Workbook object containing a worksheet.}

\item{sheet}{The worksheet to write to. Can be the worksheet index or name.}

\item{x}{Object to be written. For classes supported look at the examples.}

\item{dims}{Spreadsheet cell range that will determine \code{start_col} and \code{start_row}: "A1", "A1:B2", "A:B"}

\item{start_col}{A vector specifying the starting column to write \code{x} to.}

\item{start_row}{A vector specifying the starting row to write \code{x} to.}

\item{array}{A bool if the function written is of type array}

\item{col_names}{If \code{TRUE}, column names of \code{x} are written.}

\item{row_names}{If \code{TRUE}, the row names of \code{x} are written.}

\item{with_filter}{If \code{TRUE}, add filters to the column name row.
NOTE: can only have one filter per worksheet.}

\item{sep}{Only applies to list columns. The separator used to collapse list
columns to a character vector e.g. \code{sapply(x$list_column, paste, collapse = sep)}.}

\item{name}{The name of a named region if specified.}

\item{apply_cell_style}{Should we write cell styles to the workbook}

\item{remove_cell_style}{keep the cell style?}

\item{na.strings}{Value used for replacing \code{NA} values from \code{x}. Default
looks if \code{options(openxlsx2.na.strings)} is set. Otherwise \code{\link[=na_strings]{na_strings()}}
uses the special \verb{#N/A} value within the workbook.}

\item{inline_strings}{write characters as inline strings}

\item{enforce}{enforce that selected dims is filled. For this to work, \code{dims} must match \code{x}}

\item{...}{additional arguments}
}
\value{
invisible(0)
}
\description{
Use \code{\link[=wb_add_data]{wb_add_data()}} or \code{\link[=write_xlsx]{write_xlsx()}} in new code.
}
\keyword{internal}
