% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit.R
\name{audit}
\alias{audit}
\title{Search for Package Vulnerabilities}
\usage{
audit(pkg, version, type, verbose = TRUE)
}
\arguments{
\item{pkg}{A vector of package names to search in the OSS Index.}

\item{version}{The specific package version to search for.
By default it will search all known versions. If not \code{*}, must be the same length as pkg.}

\item{type}{The package management environment. For R packages, set equal to "cran".
This defaults to \code{"cran"}. See https://ossindex.sonatype.org/ecosystems.}

\item{verbose}{Default \code{TRUE}.}
}
\description{
Search the OSS Index for known package vulnerabilities in any of the supported ecosystems—
e.g. CRAN, PyPI, Conda, NPM, Maven, etc.
see https://ossindex.sonatype.org/ecosystems for full list.
}
\examples{
\donttest{
pkg = c("abind", "acepack")
version = c("1.4-5", "1.4.1")
audit(pkg, version, type = "cran")
}
}
