#  Copyright 2023 Commonwealth Scientific and Industrial Research #  Organisation (CSIRO) ABN 41 687 119 230. #
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

#
#' Synthetic conditions data
#'
#' A synthetic data set of simplified and flattened FHIR Condition resources generated by Synthea.
#'
#' A data frame with 19 rows and 6 columns:
#' \itemize{
#'   \item \code{START} - The onset date
#'   \item \code{STOP} - The abatement date
#'   \item \code{PATIENT} - The ID of the patient
#'   \item \code{ENCOUNTER} - The ID of the encounter
#'   \item \code{CODE} - The SNOMED CT code of the condition
#'   \item \code{DESCRIPTION} - The display name of the condition
#' }
"conditions"

