% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.prob.R
\name{estimate.probability}
\alias{estimate.probability}
\title{Estimate Probability Vectors From Count Vectors}
\usage{
estimate.probability(x, method = "empirical")
}
\arguments{
\item{x}{a numeric vector storing count values.}

\item{method}{a character string specifying the estimation method tht should be used to estimate probabilities from input counts.}
}
\value{
a numeric probability vector.
}
\description{
This function takes a numeric count vector and returns estimated
probabilities of the corresponding counts.

The following probability estimation methods are implemented in this function:

\itemize{
\item \code{method = "empirical"} : generates the relative frequency of the data \code{x/sum(x)}.
}
}
\examples{
# generate a count vector
x <- runif(100)
# generate a probability vector from corresponding counts
x.prob <- estimate.probability(x, method = 'empirical')
}
\author{
Hajk-Georg Drost
}
