% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{canberra}
\alias{canberra}
\title{Calculate Canberra Distance}
\usage{
canberra(x, y)
}
\arguments{
\item{x}{A numeric vector}

\item{y}{A numeric vector of the same dimension as x}
}
\value{
The Canberra distance between x and y. For example, between vectors
(1,2,0) and (0,1,1), for position 1 we have (1-0)/1, for position 2 we have
(2-1)/3, and for position 3 we have abs(0-1)/1, added together this results
in 2 1/3, or 2.33. Note that a text distance of zero indicates that the
two vectors are equal, while a text distance of 1 indicates that they have
no terms in common.
}
\description{
When two vectors are given, this calculates the Canberra distance between
them; This is calculated as the sum of the absolute difference between 
corresponding elements divided by the sum of their absolute values, for 
elements that are not both zero only.
}
\examples{
canberra(c(1,2,0),c(0,1,1))
}
