% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_security.R
\name{api_security_headers}
\alias{api_security_headers}
\title{Add various security related headers to your plumber2 API}
\usage{
api_security_headers(
  api,
  content_security_policy = csp(default_src = "self", script_src = "self",
    script_src_attr = "none", style_src = c("self", "https:", "unsafe-inline"), img_src =
    c("self", "data:"), font_src = c("self", "https:", "data:"), object_src = "none",
    base_uri = "self", form_action = "self", frame_ancestors = "self",
    upgrade_insecure_requests = TRUE),
  content_security_policy_report_only = NULL,
  cross_origin_embedder_policy = NULL,
  cross_origin_opener_policy = "same-origin",
  cross_origin_resource_policy = "same-origin",
  origin_agent_cluster = TRUE,
  referrer_policy = "no-referrer",
  strict_transport_security = sts(max_age = 63072000, include_sub_domains = TRUE),
  x_content_type_options = TRUE,
  x_dns_prefetch_control = FALSE,
  x_download_options = TRUE,
  x_frame_options = "SAMEORIGIN",
  x_permitted_cross_domain_policies = "none",
  x_xss_protection = FALSE
)
}
\arguments{
\item{api}{A plumber2 api object to add the plugin to}

\item{content_security_policy}{Set the value of the \code{Content-Security-Policy}
header. See \code{\link[firesafety:csp]{firesafety::csp()}} for documentation of its values}

\item{content_security_policy_report_only}{Set the value of the
\code{Content-Security-Policy-Report-Only} header. See \code{\link[firesafety:csp]{firesafety::csp()}} for
documentation of its values}

\item{cross_origin_embedder_policy}{Set the value of the
\code{Cross-Origin-Embedder-Policy}. Possible values are \code{"unsafe-none"},
\code{"require-corp"}, and \code{"credentialless"}}

\item{cross_origin_opener_policy}{Set the value of the
\code{Cross-Origin-Opener-Policy}. Possible values are \code{"unsafe-none"},
\code{"same-origin-allow-popups"}, \code{"same-origin"}, and
\code{"noopener-allow-popups"}}

\item{cross_origin_resource_policy}{Set the value of the
\code{Cross-Origin-Resource-Policy}. Possible values are \code{"same-site"},
\code{"same-origin"}, and \code{"cross-origin"}}

\item{origin_agent_cluster}{Set the value of the
\code{Origin-Agent-Cluster}. Possible values are \code{TRUE} and \code{FALSE}}

\item{referrer_policy}{Set the value of the
\code{Referrer-Policy}. Possible values are \code{"no-referrer"},
\code{"no-referrer-when-downgrade"}, \code{"origin"}, \code{"origin-when-cross-origin"},
\code{"same-origin"}, \code{"strict-origin"}, \code{"strict-origin-when-cross-origin"},
and \code{"unsafe-url"}}

\item{strict_transport_security}{Set the value of the
\code{Strict-Transport-Security} header. See \code{\link[firesafety:sts]{firesafety::sts()}} for documentation
of its values}

\item{x_content_type_options}{Set the value of the
\code{X-Content-Type-Options}. Possible values are \code{TRUE} and \code{FALSE}}

\item{x_dns_prefetch_control}{Set the value of the
\code{X-DNS-Prefetch-Control}. Possible values are \code{TRUE} and \code{FALSE}}

\item{x_download_options}{Set the value of the
\code{X-Download-Options}. Possible values are \code{TRUE} and \code{FALSE}}

\item{x_frame_options}{Set the value of the
\code{X-Frame-Options}. Possible values are \code{"DENY"} and \code{"SAMEORIGIN"}}

\item{x_permitted_cross_domain_policies}{Set the value of the
\code{X-Permitted-Cross-Domain-Policies}. Possible values are \code{"none"},
\code{"master-only"}, \code{"by-content-type"}, \code{"by-ftp-filename"}, \code{"all"}, and
\code{"none-this-response"}}

\item{x_xss_protection}{Set the value of the
\code{X-XSS-Protection}. Possible values are \code{TRUE} and \code{FALSE}}
}
\value{
This functions return the \code{api} object allowing for easy chaining
with the pipe
}
\description{
This function adds the \link[firesafety:SecurityHeaders]{SecurityHeaders} plugin
to your plumber2 API. Please consult the documentation for the plugin for
up-to-date information on its behaviour.
}
\section{Using annotation}{
Security headers doesn't have a dedicated annotation tag, but you can set
it up in a \verb{@plumber} block

\if{html}{\out{<div class="sourceCode">}}\preformatted{#* @plumber
function(api) \{
  api |>
    api_security_headers()
\}
}\if{html}{\out{</div>}}
}

\examples{
# Add default security headers to an API
api() |>
  api_security_headers()

}
\seealso{
Other security features: 
\code{\link{api_security_cors}()},
\code{\link{api_security_resource_isolation}()}
}
\concept{security features}
