//
//  utilita.h
//  POSet
//
//  Created by Alessandro Avellone on 09/04/2019.
//  Copyright © 2019 Alessandro Avellone. All rights reserved.
//

#ifndef utilita_hpp
#define utilita_hpp

#include <list>
#include "matrice.h"
#include "displayMessage.h"

std::string& FindAndReplaceAll(std::string& data, std::string toSearch, std::string replaceStr);
std::string matri_to_string(std::vector<std::vector<double>>&);
std::string to_bitstring (std::uint64_t numero, std::uint64_t cardinality);


std::vector<std::string>& split(const std::string &text, char sep);
void LTrim(std::string &s);
void RTrim(std::string &s);
void Trim(std::string &s);

//***********************************************//
//***********************************************//
//***********************************************//

template<typename Base, typename T>
inline bool instanceof(const T *ptr) {
   return dynamic_cast<const Base*>(ptr) != nullptr;
}

//************************************
//************************************
//************************************

template<class Type>
std::string to_string(std::set<Type>& s, char DELIMETER = ';') {
    std::string r = "";
    std::uint64_t conta = 0;
    for (auto e : s) {
        if (++conta < s.size()) {
            r += DELIMETER + std::to_string(e);
        }
        else
        {
            r += std::to_string(e);
        }
    }
    return r;
}


//************************************
//************************************
//************************************

template<class Type>
std::string vector_to_string(std::vector<Type>& v, char DELIMETER = ';') {
    std::string r = "";
    for (size_t h = 0; h < v.size(); ++h) {
        if (h < v.size() - 1) {
            r += std::to_string(v[h]) + DELIMETER;
        }
        else
        {
            r += std::to_string(v[h]);
        }
    }
    return r;
}



#endif /* utilita_hpp */
