% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_data.R
\docType{data}
\name{ppiGHA2015_b}
\alias{ppiGHA2015_b}
\title{Poverty Probability Index (PPI) lookup table for Ghana using poverty
definitions deflated with the change in 100\% of national poverty line}
\format{
A data frame with 8 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp200}}{Below $2.00 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
\item{\code{ppp375}}{Below $3.75 per day purchasing power parity (2005)}
\item{\code{ppp500}}{Below $5.00 per day purchasing power parity (2005)}
\item{\code{ppp190}}{Below $1.90 per day purchasing power parity (2011)}
\item{\code{ppp310}}{Below $3.10 per day purchasing power parity (2011)}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiGHA2015_b
}
\description{
Poverty Probability Index (PPI) lookup table for Ghana using poverty
definitions deflated with the change in 100\% of national poverty line
}
\examples{
  # Access Ghana PPI table
  ppiGHA2015_b

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiGHA2015_b[ppiGHA2015_b$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiGHA2015_b, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the below $1.25
  # per day purchasing power parity (2005)
  ppiScore <- 50
  ppiGHA2015_b[ppiGHA2015_b$score == ppiScore, "ppp125"]

}
\keyword{datasets}
