% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg.R
\name{reg}
\alias{reg}
\title{Build regression models}
\usage{
reg(data = NULL, x = NULL, y = NULL, group = NULL, cov = NULL,
  factors = NULL, model = NULL, time = NULL, cov_show = FALSE,
  confint_glm = "default", group_combine = FALSE)
}
\arguments{
\item{data}{A data.frame to build the regression model.}

\item{x}{Integer column indices or names of the variables to be included in univariate analysis. If \code{NULL}, the default columns are all the variables except `y`, `group`, `time` and `cov`.}

\item{y}{Integer column indice or name of dependent variables, integer or character, allow more than one dependent variables}

\item{group}{Integer column indice or name of subgroup variables.}

\item{cov}{Integer column indices or name of covariate variables}

\item{factors}{Integer column indices or names of variables to be treated as factor}

\item{model}{regression model, see \code{\link{lm}}, \code{\link{glm}}, \code{\link[survival]{coxph}} for more details}

\item{time}{Integer column indices  or name of survival time, used in cox regression, see \code{\link[survival]{coxph}} for more details}

\item{cov_show}{A logical, whether to create covariates result, default FALSE}

\item{confint_glm}{A character, 'default' or 'profile'. The default method for 'glm' class to compute confidence intervals assumes asymptotic normality \code{\link[stats]{confint}}, you can also use profile likelihood method \code{\link[MASS]{confint.glm}}, but it is pretty slow.
In this case you could specify 'default' for speed.}

\item{group_combine}{A logical, subgroup analysis for combination of group variables or each group variables. The default is FALSE (subgroup analysis for each group variable)}
}
\value{
The return result is a concentrated result in a  data.frame.
}
\description{
Build general linear model, logistic regression model, cox regression model with one or more dependent variables. Allow regression based on subgroup variables.
}
