% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-sample_sets.R
\docType{class}
\name{sample_sets-class}
\alias{sample_sets-class}
\title{An S4 class to represent a set of PGS Catalog Sample Sets}
\description{
The sample_sets object consists of four tables (slots) that combined form a
relational database of a subset of PGS Catalog sample sets. Each sample set
is an observation (row) in the \code{sample_sets} table (first table).
}
\section{Slots}{

\describe{
\item{\code{sample_sets}}{A table of sample sets. Each sample set (row) is uniquely
identified by the column \code{pss_id}. Columns:
\describe{
\item{pss_id}{A PGS Sample Set identifier. Example: \code{"PSS000042"}.}
}}

\item{\code{samples}}{A table of samples. Each sample (row) is uniquely identified by
the combination of values from the columns: \code{pss_id} and
\code{sample_id}. Columns:
\describe{
\item{pss_id}{A PGS Sample Set identifier. Example: \code{"PSS000042"}.}
\item{sample_id}{Sample identifier. This is a surrogate key to identify each sample.}
\item{stage}{Sample stage: should be always Evaluation (\code{"eval"}).}
\item{sample_size}{Number of individuals included in the sample.}
\item{sample_cases}{Number of cases.}
\item{sample_controls}{Number of controls.}
\item{sample_percent_male}{Percentage of male participants.}
\item{phenotype_description}{Detailed phenotype description.}
\item{ancestry_category}{Author reported ancestry is mapped to the best matching
ancestry category from the NHGRI-EBI GWAS Catalog framework (see
\code{\link[quincunx]{ancestry_categories}}) for possible values.}
\item{ancestry}{A more detailed description of sample ancestry
that usually matches the most specific description described by the authors
(e.g. French, Chinese).}
\item{country}{Author reported countries of recruitment (if available).}
\item{ancestry_additional_description}{Any additional description not
captured in the other columns (e.g. founder or genetically isolated
populations, or further description of admixed samples).}
\item{study_id}{Associated GWAS Catalog study accession identifier, e.g.,
\code{"GCST002735"}.}
\item{pubmed_id}{\href{https://en.wikipedia.org/wiki/PubMed}{PubMed}
identifier.}
\item{cohorts_additional_description}{Any additional description about the
samples (e.g. sub-cohort information).}
}}

\item{\code{demographics}}{A table of sample demographics' variables. Each
demographics' variable (row) is uniquely identified by the combination of
values from the columns: \code{pss_id}, \code{sample_id}, and
\code{variable}. Columns:
\describe{
\item{pss_id}{A PGS Sample Set identifier. Example: \code{"PSS000042"}.}
\item{sample_id}{Sample identifier. This is a surrogate identifier to
identify each sample.}
\item{variable}{Demographics variable. Following columns report about the
indicated variable.}
\item{estimate_type}{Type of statistical estimate for variable.}
\item{estimate}{The variable's statistical value.}
\item{unit}{Unit of the variable.}
\item{variability_type}{Measure of statistical dispersion for variable, e.g.
standard error (se) or standard deviation (sd).}
\item{variability}{The value of the measure of dispersion.}
\item{interval_type}{Type of statistical interval for variable: range, iqr
(interquartile), ci (confidence interval).}
\item{interval_lower}{Interval lower bound.}
\item{interval_upper}{Interval upper bound.}
}}

\item{\code{cohorts}}{A table of cohorts. Each cohort (row) is uniquely identified by
the combination of values from the columns: \code{pss_id}, \code{sample_id}
and \code{cohort_symbol}. Columns:
\describe{
\item{pss_id}{A PGS Sample Set identifier. Example: \code{"PSS000042"}.}
\item{sample_id}{Sample identifier. This is a surrogate key to identify each sample.}
\item{cohort_symbol}{Cohort symbol.}
\item{cohort_name}{Cohort full name.}
}}
}}

