# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Clean things up
#'
#' @noRd
freeSpace <- function() {
    invisible(.Call('_rSpectral_freeSpace', PACKAGE = 'rSpectral'))
}

#' Load edge list for analysis
#' 
#' This function reads the edge list and creates the network for analysis. It does 
#' not return anything, it just creates required structures in memory.
#'
#' @param df edge list
#' @param names are we dealing with alphaNumeric (1) or numeric (!1) ids
#' @noRd
#'
#' @examples
#' library(igraph)
#' g <- make_full_graph(5) %du% make_full_graph(5) %du% make_full_graph(5)
#' g <- add_edges(g, c(1,6, 1,11, 6, 11))
#' el = as.data.frame(get.edgelist(g,names=TRUE))
#' rSpectral::load_data(df=el)
#' status = rSpectral::spectral(fix_neig=0)
#' spec   = rSpectral::membership(detach_graph=1)
load_data <- function(df, names = 1L) {
    invisible(.Call('_rSpectral_load_data', PACKAGE = 'rSpectral', df, names))
}

#' Spectral modularity calculation function
#' 
#' This function implements the network clustering algorithm described in
#' (M. E. J. Newman, 2006). 
#' 
#' The complete iterative algorithm comprises of two steps. In the
#' first step, the network is expressed in terms of its leading eigenvalue and eigenvector
#' and recursively partition into two communities. Partitioning occurs if the maximum
#' positive eigenvalue is greater than the tolerance (\code{tol=10-5}) for the current
#' partition, and if it results in a positive contribution to the Modularity.
#'
#' Given an initial separation using the leading eigen step, the function then continues to
#' maximise for the change in Modularity using a fine-tuning step - or variate thereof. The
#' first stage here is to find the node which, when moved from one community to another,
#' gives the maximum change in Modularity. This node’s community is then fixed and we repeat
#' the process until all nodes have been moved. The whole process is repeated from this new
#' state until the change in the Modularity, between the new and old state, is less than the
#' predefined tolerance (\code{tol}).
#'
#' A slight variant of the fine-tuning step, which can reduce execution time by factor 2 to
#' 5, is also provided. Instead of moving each node into each community in turn, we only
#' consider moves of neighbouring nodes, found in different communities, to the community of
#' the current node of interest. This variant of the node-moving algorithm effectively `fixes`
#' neigbouring nodes \code{fix_neig} in the community being considered.
#'
#' The two steps process is repeatedly applied to each new community found, subdivided each community
#' into two new communities, until we are unable to find any division that results in a positive change
#' in Modularity. An additional stopping criteria, based on the minimum cluster size \code{Cn_min}, is
#' also provided.
#'
#' Optimal set of parameters could be obtained by trying different combinations of values and using
#' \code{detach_graph=0} when getting communities by calling \code{\link{membership}}. 
#'
#' @param Cn_min minimum cluster size
#' @param tol tolerance
#' @param names are we dealing with alphaNumeric (1) or numeric (!1) ids
#' @param fix_neig whether to fix neighbouring nodes found in same community
#' 
#' @noRd
#'
#' @examples
#' library(igraph)
#' g <- make_full_graph(5) %du% make_full_graph(5) %du% make_full_graph(5)
#' g <- add_edges(g, c(1,6, 1,11, 6, 11))
#' el = as.data.frame(get.edgelist(g,names=TRUE))
#' rSpectral::load_data(df=el)
#' status = rSpectral::spectral(fix_neig=0)
#' spec   = rSpectral::membership(detach_graph=1)
#' V(g)$color[as.numeric(spec$ID)]<-RColorBrewer::brewer.pal(max(spec$K),'Set1')[spec$K]
#' plot(g)
spectral <- function(Cn_min = 1L, tol = 0.00001, names = 1L, fix_neig = 0L) {
    invisible(.Call('_rSpectral_spectral', PACKAGE = 'rSpectral', Cn_min, tol, names, fix_neig))
}

#' Return membership data
#'
#' Returns membership data calculated by previous call to \code{\link{spectral}}.
#' If \code{detach_grap} is set to 1 (default) all in-memory data will be cleaned up
#' on return, if \code{detach_grap} is set to 0 the graph stays in memory,
#' so several sets of parameters such as \code{fix_neig}, or \code{Cn_min} 
#' could be evaluated to identify the best clustering for the graph at hand.
#' 
#' @param detach_graph whether you want to keep graph in memory
#' 
#' @noRd
#'
#' @return membership vector
#'
#' @examples
#' library(igraph)
#' g <- make_full_graph(5) %du% make_full_graph(5) %du% make_full_graph(5)
#' g <- add_edges(g, c(1,6, 1,11, 6, 11))
#' el = as.data.frame(get.edgelist(g,names=TRUE))
#' rSpectral::load_data(df=el)
#' status1 = rSpectral::spectral(fix_neig=0)
#' spec1   = rSpectral::membership(detach_graph=0)
#' status2 = rSpectral::spectral(fix_neig=1)
#' spec2   = rSpectral::membership(detach_graph=0)
membership <- function(detach_graph = 1L) {
    .Call('_rSpectral_membership', PACKAGE = 'rSpectral', detach_graph)
}

