% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite.R
\name{gd_composite}
\alias{gd_composite}
\title{Composite an Image Collection}
\usage{
gd_composite(x, ...)
}
\arguments{
\item{x}{an object inheriting from \code{geedim.collection.MaskedCollection}, such as from \code{gd_search()} or \code{gd_collection_from_list()}}

\item{...}{\href{https://geedim.readthedocs.io/en/latest/_generated/geedim.collection.MaskedCollection.composite.html}{additional arguments} to \code{geedim.collection.MaskedCollection$composite()}}
}
\value{
a composite \code{geedim.mask.MaskedImage} object
}
\description{
Create a composite image from elements of an image collection.
}
\examples{
\dontshow{if (gd_is_initialized() && !inherits(requireNamespace("terra", quietly=TRUE), 'try-error')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(terra)

b <- terra::vect('POLYGON((-121.355 37.560, 
                           -121.355 37.555,
                           -121.350 37.555, 
                           -121.350 37.560,
                           -121.355 37.560))',
                 crs = "OGC:CRS84")

if (gd_is_initialized())
  gd_composite(gd_search(gd_collection_from_name("USGS/3DEP/1m"),
                         region = b),
               resampling = "bilinear")
}
\dontshow{\}) # examplesIf}
}
