% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_package_host_info.R
\name{get_cran_package_url}
\alias{get_cran_package_url}
\title{Get CRAN Package URL}
\usage{
get_cran_package_url(package_name, version, last_version, all_versions)
}
\arguments{
\item{package_name}{A character string specifying the name of the package.}

\item{version}{An optional character string specifying the version of the package.
If `NULL`, the latest version is assumed.}

\item{last_version}{A named list with elements version and date, 
representing the latest available version and its publication date.}

\item{all_versions}{A list of named lists, each with elements version and date, 
representing all known versions of the package and their publication dates.}
}
\value{
A character string containing the URL to download the package tarball,
or "No valid URL found" if the version is not found in the list of available versions.
}
\description{
This function constructs the CRAN package URL for a specified package and version.
}
\examples{
\dontrun{
# Example data structure
last_version <- list(version = "1.0.10", date = "2024-01-01")
all_versions <- list(
  list(version = "1.0.0", date = "2023-01-01"),
  list(version = "1.0.10", date = "2024-01-01")
)

# Get the URL for the latest version of "dplyr"
url <- get_cran_package_url("dplyr", NULL, last_version, all_versions)
print(url)
}
}
