% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_util.R
\name{is_matrix}
\alias{is_matrix}
\title{Verify a 2x2 matrix as a numeric contingency table.}
\usage{
is_matrix(mx)
}
\arguments{
\item{mx}{An object to verify (required).}
}
\value{
A Boolean value: \code{TRUE} if \code{mx}
is a numeric matrix and 2x2 contingency table;
otherwise \code{FALSE}.
}
\description{
\code{is_matrix} verifies that \code{mx} is a
valid 2x2 matrix (i.e., a numeric contingency table).
}
\details{
\code{is_matrix} is more restrictive than \code{\link{is.matrix}},
as it also requires that \code{mx} \code{\link{is.numeric}},
\code{\link{is.table}}, \code{nrows(mx) == 2}, and \code{ncols(mx) == 2}.
}
\examples{
is_matrix(1:4)
is_matrix(matrix("A"))
is_matrix(matrix(1:4))
is_matrix(as.table(matrix(1:4, nrow = 1, ncol = 4)))
is_matrix(as.table(matrix(1:4, nrow = 4, ncol = 1)))
is_matrix(as.table(matrix(1:4, nrow = 2, ncol = 2)))

}
\references{
Neth, H., Gradwohl, N., Streeb, D., Keim, D.A., & Gaissmaier, W. (2021).
Perspectives on the 2×2 matrix: Solving semantically distinct problems
based on a shared structure of binary contingencies.
\emph{Frontiers in Psychology}, \emph{11}, 567817.
doi: \doi{10.3389/fpsyg.2020.567817}
}
\seealso{
Other verification functions: 
\code{\link{is_complement}()},
\code{\link{is_extreme_prob_set}()},
\code{\link{is_freq}()},
\code{\link{is_integer}()},
\code{\link{is_perc}()},
\code{\link{is_prob}()},
\code{\link{is_suff_prob_set}()},
\code{\link{is_valid_prob_pair}()},
\code{\link{is_valid_prob_set}()},
\code{\link{is_valid_prob_triple}()}
}
\concept{verification functions}
