% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-entrace.R
\name{global_entrace}
\alias{global_entrace}
\title{Entrace unexpected errors}
\usage{
global_entrace(enable = TRUE, class = c("error", "warning", "message"))
}
\arguments{
\item{enable}{Whether to enable or disable global handling.}

\item{class}{A character vector of one or several classes of
conditions to be entraced.}
}
\description{
\code{global_entrace()} enriches base errors, warnings, and messages
with rlang features.
\itemize{
\item They are assigned a backtrace. You can configure whether to
display a backtrace on error with the \link{rlang_backtrace_on_error}
global option.
\item They are recorded in \code{\link[=last_error]{last_error()}}, \code{\link[=last_warnings]{last_warnings()}}, or
\code{\link[=last_messages]{last_messages()}}. You can inspect backtraces at any time by
calling these functions.
}

Set global entracing in your RProfile with:

\if{html}{\out{<div class="sourceCode">}}\preformatted{rlang::global_entrace()
}\if{html}{\out{</div>}}
}
\section{Inside RMarkdown documents}{


Call \code{global_entrace()} inside an RMarkdown document to cause
errors and warnings to be promoted to rlang conditions that include
a backtrace. This needs to be done in a separate setup chunk before
the first error or warning.

This is useful in conjunction with
\code{\link{rlang_backtrace_on_error_report}} and
\code{\link{rlang_backtrace_on_warning_report}}. To get full entracing in an
Rmd document, include this in a setup chunk before the first error
or warning is signalled.

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{r setup\}
rlang::global_entrace()
options(rlang_backtrace_on_warning_report = "full")
options(rlang_backtrace_on_error_report = "full")
```
}\if{html}{\out{</div>}}
}

\section{Under the hood}{

On R 4.0 and newer, \code{global_entrace()} installs a global handler
with \code{globalCallingHandlers()}. On older R versions, \code{entrace()} is
set as an \code{option(error = )} handler. The latter method has the
disadvantage that only one handler can be set at a time. This means
that you need to manually switch between \code{entrace()} and other
handlers like \code{\link[=recover]{recover()}}. Also this causes a conflict with IDE
handlers (e.g. in RStudio).
}

