% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WILCOX_DDCt.R
\name{WILCOX_DDCt}
\alias{WILCOX_DDCt}
\title{Delta Delta Ct method wilcox.test analysis}
\usage{
WILCOX_DDCt(
  x,
  numberOfrefGenes,
  Factor.level.order = NULL,
  paired = FALSE,
  p.adj = "none",
  order = "none"
)
}
\arguments{
\item{x}{A data frame containing experimental conditions, biological replicates, and
amplification efficiency and Ct values for target and reference genes.
The number of biological replicates must be equal across genes. If this 
is not true, or there are \code{NA} values use \code{ANODA_DDCt} function 
for independent samples or \code{REPEATED_DDCt} for paired samples.
See the package vignette for details on the required data structure.}

\item{numberOfrefGenes}{Integer specifying the number of reference genes used for normalization.}

\item{Factor.level.order}{Optional character vector specifying the order of factor levels.
If \code{NULL}, the first level of the factor column is used as the calibrator.}

\item{paired}{Logical; if \code{TRUE}, a paired wilcox.test is performed.}

\item{p.adj}{Method for p-value adjustment. One of
\code{"holm"}, \code{"hochberg"}, \code{"hommel"}, \code{"bonferroni"},
\code{"BH"}, \code{"BY"}, \code{"fdr"}, or \code{"none"}. See \code{\link[stats]{p.adjust}}.}

\item{order}{Optional character vector specifying the order of genes in the output plot.}
}
\value{
A table containing RE values, log2FC, p-values, significance, 
confidence intervals, standard errors, and lower/upper SE limits.
}
\description{
The \code{WILCOX_DDCt} function performs fold change expression analysis based on
the \eqn{\Delta \Delta C_T} method using wilcox.test. It supports analysis
of one or more target genes evaluated under two experimental conditions
(e.g. control vs treatment).
}
\details{
Relative expression values are computed using reference gene(s) for normalization.
Both paired and unpaired experimental designs are supported.

Paired samples in quantitative PCR refer to measurements collected from the same
individuals under two different conditions (e.g. before vs after treatment),
whereas unpaired samples originate from different individuals in each condition.
Paired designs allow within-individual comparisons and typically reduce
inter-individual variability.

The function returns expression table. The expression table returned by `TTEST_DDCt()`, 
`WILCOX_DDCt()`, `ANOVA_DDCt()`, `ANCOVA_DDCt()`, and `REPEATED_DDCt()` functions 
include these columns: gene (name of target genes), 
contrast (calibrator level and contrasts for which the relative expression is computed), 
RE (relative expression or fold change),  log2FC (log(2) of relative expression or fold change), 
pvalue, sig (per-gene significance), LCL (95\% lower confidence level), UCL (95\% upper confidence level),
se (standard error of mean calculated from the weighted delta Ct values of each of the main factor levels),
Lower.se.RE (The lower limit error bar for RE which is 2^(log2(RE) - se)), 
Upper.se.RE (The upper limit error bar for RE which is 2^(log2(RE) + se)),
Lower.se.log2FC (The lower limit error bar for log2 RE), and 
Upper.se.log2FC (The upper limit error bar for log2 RE)
}
\examples{
# Example data structure
data <- read.csv(system.file("extdata", "data_Yuan2006PMCBioinf.csv", package = "rtpcr"))

# Unpaired t-test
WILCOX_DDCt(
  data,
  paired = FALSE,
  numberOfrefGenes = 1)


# Two reference genes
data2 <- read.csv(system.file("extdata", "data_1factor_Two_ref.csv", package = "rtpcr"))
WILCOX_DDCt(
  data2,
  numberOfrefGenes = 2,
  p.adj = "none")
}
\references{
Yuan, J. S., Reed, A., Chen, F., and Stewart, N. (2006).
Statistical Analysis of Real-Time PCR Data.
\emph{BMC Bioinformatics}, 7, 85.
}
\author{
Ghader Mirzaghaderi
}
