% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/salt_insert.R
\name{salt_insert}
\alias{salt_insert}
\title{Insert new characters into some values in a vector}
\usage{
salt_insert(x, insertions, p = 0.2, n = 1)
}
\arguments{
\item{x}{A vector. This will always be coerced to character during salting.}

\item{insertions}{A \link{shaker} function, or a character vector.}

\item{p}{A number between 0 and 1. Percent of values in \code{x} that should be
salted.}

\item{n}{A positive integer. Number of times to add new values from
\code{insertions} into selected values in \code{x} manually supply your own list of
characters.}
}
\value{
A character vector the same length as \code{x}
}
\description{
Inserts a selection of characters into a percentage of values in the supplied
vector.
}
