% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semmcci-mc-func.R
\name{MCFunc}
\alias{MCFunc}
\title{Monte Carlo Confidence Intervals (Function)}
\usage{
MCFunc(
  coef,
  vcov,
  func,
  ...,
  R = 20000L,
  alpha = c(0.001, 0.01, 0.05),
  decomposition = "eigen",
  pd = TRUE,
  tol = 1e-06,
  seed = NULL,
  ncores = NULL
)
}
\arguments{
\item{coef}{Numeric vector.
Vector of estimated parameters.}

\item{vcov}{Numeric matrix.
Sampling variance-covariance matrix of estimated parameters.}

\item{func}{R function.
\enumerate{
\item The first argument \code{x} is the argument \code{coef}.
\item The function algebraically manipulates \code{coef}
to return at a new numeric vector.
It is best to have a named vector as an output.
\item The function can take additional named arguments
passed using \code{...}.
}}

\item{...}{Additional arguments to pass to \code{func}.}

\item{R}{Positive integer.
Number of Monte Carlo replications.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.}

\item{decomposition}{Character string.
Matrix decomposition of the sampling variance-covariance matrix
for the data generation.
If \code{decomposition = "chol"}, use Cholesky decomposition.
If \code{decomposition = "eigen"}, use eigenvalue decomposition.
If \code{decomposition = "svd"}, use singular value decomposition.}

\item{pd}{Logical.
If \code{pd = TRUE},
check if the sampling variance-covariance matrix
is positive definite using \code{tol}.}

\item{tol}{Numeric.
Tolerance used for \code{pd}.}

\item{seed}{Integer.
Random seed for reproducibility.}

\item{ncores}{Positive integer.
Number of cores to use.
If \code{ncores = NULL}, use single core.}
}
\value{
Returns an object of class \code{semmcci} which is
a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{List of function arguments.}
\item{thetahat}{Parameter estimates \eqn{\hat{\theta}}.}
\item{thetahatstar}{Sampling distribution of parameter estimates
\eqn{\hat{\theta}^{\ast}}.}
\item{fun}{Function used ("MCFunc").}
}
}
\description{
Calculates Monte Carlo confidence intervals
for defined parameters.
}
\details{
A sampling distribution of parameter estimates is generated
from the multivariate normal distribution
using the parameter estimates and the sampling variance-covariance matrix.
Confidence intervals for defined parameters
are generated using the simulated sampling distribution.
Parameters are defined using the \code{func} argument.
}
\examples{
library(semmcci)

## MCFunc() ----------------------------------------------------------------
### Define func ------------------------------------------------------------
func <- function(x) {
  out <- exp(x)
  names(out) <- "exp"
  return(out)
}
### Generate Confidence Intervals ------------------------------------------
MCFunc(
  coef = 0,
  vcov = matrix(1),
  func = func,
  R = 5L, # use a large value e.g., 20000L for actual research
  alpha = 0.05
)

}
\references{
MacKinnon, D. P., Lockwood, C. M., & Williams, J. (2004).
Confidence limits for the indirect effect:
Distribution of the product and resampling methods.
\emph{Multivariate Behavioral Research}, \emph{39}(1), 99-128.
\doi{10.1207/s15327906mbr3901_4}

Pesigan, I. J. A., & Cheung, S. F. (2023).
Monte Carlo confidence intervals for the indirect effect with missing data.
\emph{Behavior Research Methods}.
\doi{10.3758/s13428-023-02114-4}

Preacher, K. J., & Selig, J. P. (2012).
Advantages of Monte Carlo confidence intervals for indirect effects.
\emph{Communication Methods and Measures}, \emph{6}(2), 77–98.
\doi{10.1080/19312458.2012.679848}
}
\seealso{
Other Monte Carlo in Structural Equation Modeling Functions: 
\code{\link{Func}()},
\code{\link{MC}()},
\code{\link{MCGeneric}()},
\code{\link{MCMI}()},
\code{\link{MCStd}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Monte Carlo in Structural Equation Modeling Functions}
\keyword{mc}
\keyword{semmcci}
