% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymmetric_and_causal_Shapley.R
\name{create_marginal_data_training}
\alias{create_marginal_data_training}
\title{Function that samples data from the empirical marginal training distribution}
\usage{
create_marginal_data_training(
  x_train,
  n_explain,
  Sbar_features,
  n_MC_samples = 1000,
  stable_version = TRUE
)
}
\arguments{
\item{x_train}{Data.table with training data.}

\item{Sbar_features}{Vector of integers containing the features indices to generate marginal observations for.
That is, if \code{Sbar_features} is \code{c(1,4)}, then we sample \code{n_MC_samples} observations from \eqn{P(X_1, X_4)} using the
empirical training observations (with replacements). That is, we sample the first and fourth feature values from
the same training observation, so we do not break the dependence between them.}

\item{stable_version}{Logical. If \code{TRUE} and \code{n_MC_samples} > \code{n_train}, then we include each training observation
\code{n_MC_samples \%/\% n_train} times and then sample the remaining \verb{n_MC_samples \%\% n_train samples}. Only the latter is
done when \code{n_MC_samples < n_train}. This is done separately for each explicand. If \code{FALSE}, we randomly sample the
from the observations.}
}
\value{
Data table of dimension \code{n_MC_samples} \eqn{\times} \code{length(Sbar_features)} with the sampled observations.
}
\description{
Sample observations from the empirical distribution P(X) using the training dataset.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
