% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_shinytest2.R
\name{benchmark_shinytest2}
\alias{benchmark_shinytest2}
\title{Run the performance test based on a multiple commits using shinytest2}
\usage{
benchmark_shinytest2(
  commit_list,
  shinytest2_dir,
  tests_pattern,
  app_dir,
  use_renv,
  renv_prompt,
  n_rep,
  debug
)
}
\arguments{
\item{commit_list}{A list of commit hash codes, branches' names or anything
else you can use with git checkout \link{...}}

\item{shinytest2_dir}{The directory with tests recorded by shinytest2
It can also be a vector of the same size of commit_list}

\item{tests_pattern}{shinytest2 files pattern. E.g. 'performance'
It can also be a vector of the same size of commit_list. If it is NULL,
all the content in cypress_dir/shinytest2_dir will be used}

\item{app_dir}{The path to the application root}

\item{use_renv}{In case it is set as TRUE, package will try to apply
renv::restore() in all branches. Otherwise, the current loaded list of
packages will be used in all branches.}

\item{renv_prompt}{Prompt the user before taking any action?}

\item{n_rep}{Number of replications desired}

\item{debug}{Logical. TRUE to display all the system messages on runtime}
}
\value{
Return a \code{list} with the collected performance times
}
\description{
Run the performance test based on a multiple commits using shinytest2
}
